(***********************************************************************

                    Mathematica-Compatible Notebook

This notebook can be used on any computer system with Mathematica 3.0,
MathReader 3.0, or any compatible application. The data for the notebook 
starts with the line of stars above.

To get the notebook into a Mathematica-compatible application, do one of 
the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing the 
word CacheID, otherwise Mathematica-compatible applications may try to 
use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
***********************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[     98682,       1680]*)
(*NotebookOutlinePosition[    109069,       2027]*)
(*  CellTagsIndexPosition[    108848,       2017]*)
(*WindowFrame->Palette*)



Notebook[{
Cell[BoxData[GridBox[{
        {
          ButtonBox["Help",
            ButtonFunction:>(FrontEndExecute[ {
                FrontEnd`HelpBrowserLookup[ #]}]&),
            ButtonData:>""], 
          ButtonBox[\(Contact\ Information\),
            ButtonData:>"ContactInformation"], 
          ButtonBox["Credits",
            ButtonData:>"Credits"], 
          ButtonBox[\(License\ Agreement\),
            ButtonData:>"LicenseAgreement"], 
          ButtonBox["Top",
            ButtonData:>"Top"], 
          ButtonBox["Print",
            ButtonData:>"Top",
            ButtonStyle->"PrintButton"]}
        }]], "ButtonBar",
  CellMargins->{{0, 0}, {0, 0}},
  CellFrameMargins->{{0, 8}, {0, 8}},
  FontFamily->"Helvetica",
  Background->GrayLevel[0],
  CellTags->"Top"],

Cell[TextData[ValueBox["$ExpirationString"]], "TopMatter",
  CellMargins->{{Inherited, Inherited}, {0, 0}},
  FontWeight->"Bold",
  FontColor->RGBColor[0.0154879, 0.897581, 0.88574],
  CellTags->"Top"],

Cell[GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40005V0000`@P10`4000010?ooooooc?ooZ_ooI_oo
<ooo0?o<ooo<c?o<VC/k>gYjN[Vi^OShn03ooeGooj[ooonI<onI0?mVoomVc?mVVOmVI_mV<omV0?lc
oclo?ginO[fm_Oclo5D00:X00?l00?l0VOl0I_l0<ol00<coolcoc<coVLcoIP<30d92@X61PL30`000
EED0EJX0EOl0ELbIolbIc<bIVLbII/bI<lbI0<aVolaVc0L71dI6AXF5QLC4a000ZUD0ZZX0Z_l0Z/`c
<l`c0<`0ol`0c<`0VL`0I/`0<l`000/;2dY:BXV9RLS8b000oeD0ojX0ool0oiW<VIW<IYW<<iW<09VI
oiVIc9VIVIVIIPl?3di>CXf=SLc<c01E05EE0:YE0?mE09TcoiTcc9TcVITcIYTc<iTc09T0oiT0c1<C
4e9BDY6ATM3@d01EEEEEEJYEEOmEEFKo<fKo06K<ofK<c6K<VFK<IVK<<fK<01LG5eIFEYFEUMCDe01E
ZUEEZZYEZ_mEZVIVVFIVIVIV<fIV06HcofHcc6HcVFHcIQ/K6eYJFYVIVMSHf01EoeEEojYEoomEoc?o
oc?oc3?oVC?oIS?o<c?o03?<oc?<c1lO7eiNGYfMWMcLg02Z05FZ0:ZZ0?nZ03>I<c>I03=Voc=Vc3=V
VC=VIS=V<c=V02<S8f9RHZ6QXN3Ph02ZEEFZEJZZEOnZEC<0VC<0IS<0<c<0003oo`3oc03oV@3oIRLW
9fIVIZFUYNCTi02ZZUFZZZZZZ_nZZP2Io`2Ic02IV@2IIP2I<`2I001Vo`1Vc2/[:fYZJZVYZNSXj02Z
oeFZojZZoonZo`0c<`0c0000o`00c000V@00IP00<nh002l_;fi^KZf][Nc/k03o05Go0:[o0?oo0140
003^003M002k002Z0028001g001E03<c<g9bL[6a/O3`l03oEEGoEJ[oEOooE@00M`00E@00A0008P00
4Nk^k]gMgK^k^cLg=gIfM[Fe]OCdm03oZUGoZZ[oZP000?lNIah00?lNIah00?lNIah00?l0I`000?l0
I`000?l0I`000?l0I`000?l0I`000?l0I`000?l0I`000?l0I`000?l0I`000?l0I`000?l0I`000?l0
I`000?l0I`0006/000?eRoH01OH00h_e000>0003bc/K00@K00>;000020000e_fmP06mP@000>;m_H0
1OH00h_e0007000338/K00DK00?f00002@000l^;mP06mP03300000T000<<Fa/01A/00e_;00060003
38_f00Sf00<<00002P0@mP030<_f00Of00?e00000P08mP03b`0000@02OH00``000040003mH/K00DK
00?f00005P0006/000?e6a/01a/=0003ba/K00TK20096`<000>;6a/01a/00l/0000500/K00=K0000
1`000c/K6`066`03b`0000P031/00h/0000400dK00>;00001P000oDK6`0>6`0305/K00LK00G;0000
m@096`H02A/00``00002000331/K00TK00=K0000500006/000<<6a/01Q/00c/0000:0003>a/K00/K
00?e000010000c/K6`066`<02A/00c/0000600dK20000e/K6`066`03b`0000H000<<6a/03A/500lK
00<k000010000``K6`0>6`030</K00LK00Ge0000mP086`03>`0000@02A/00``000020003mA/K00/K
00<<00004P0006/000<<6a/01a/;0003Fa/K00dK00?f00000`096`<02A/00oH0000600hK1`000e/K
6`066`03R`0000H04A/4014K00<<00000`000c/K6`0=6`030?DK00LK00F;0000>`086`03>`0000@0
2A/00oH00002000331/K00`K00<<00004@0006`02A/:0003mA/K00lK00<<00000P000c/K6`066`03
m@3e00TK00<<00001P0?6`H000?f6a/01Q/00h/00005018K00AK00004Q/00oH000020003>a/K00dK
00<0mA/01a/018/0000:6`03300000<000<k6a/01Q/00l/0000300lK4`0006/000<<6a/01a/:01<K
10000h/K6`066`03b`1K00PK00>;00001`0?6`03>`0000<000>;6a/01Q/00e/00004000331/K014K
0`0C6`05m@0003/03a/200PK00B;003e2Q/00``0000300TK00?;00000`0?6`03R`000100001/00TK
2@000l/K6`0A6`05F`0008/021/00l/06`086`03b`0000L041/50003ba/K00LK1P000oHK6`0B6`80
00<k6a/04A/30003Fa/K00dK00?;01/01a/015/008/:6`03m@0000<000>;6a/01Q/00e/00003010K
4P0006`000=K6a/01Q/00oD000060003Fa/K018K0`000oHK6`066`03mP0K00LK00<k0000200@6`03
F`00008000?;6a/01a/60003Fa/K018K0P000h/K6`0A6`04R`00>`lK00?;01/01a/015/005/:6`03
b`0000<000>;6a/01Q/00h/000030003>a/K00dK00?f00003`0006`000<k6a/01Q/8000331/K00PK
00?fFa/021/015/00?D86`;f21/00h/000080007Fa/K6oK;m@0:6`@000?e6a/01a/60003Fa/K00LK
00?f>a/021/00oD0F`086`03Fa/K00TK0P000h/K6`076`08mU^;Fh]Kb`086`03>`0000/K00?;0000
0`000h/K6`066`03F`0000<011/00oKeb`0:6a40001/0003Fa/K00HK00?;00001@000oDK6`076`04
mP00F`TK0P000oDK6`066`03bc/K00LK00<<0000200018/K6``400TK10000``K6`076`H000<k6a/0
1Q/018/003/86`03R`3f00PK00>;03/02A/00oH0mP086`03F`0000H02A/00`3e6`0:6`03mP0000<0
00?e6a/01Q/00c/000030004>a/K30@02A/A0000K0000oHK6`066`03R`0000D000?;6a/01a/400TK
00?e000021/00c/K6`066`03F`0000T000?f6`001@000c/K6`066`05m@0000`02A/60003>a/K00HK
00Ce003;21/00e/0m@086`03F`0000TK00<k0?H021/00e/0000600PK00<k0?H02a/00e/000030003
mA/K00HK00<k00000`000h/K000500TK4@0006`000>;6a/01Q/00l/000050003mQ/K00LK10000h/K
6`066`03>`00014K00?f00002@000l/k00040003Fa/K00LK00<<00000P096`03300000<000=K6a/0
1Q/01?H00?D96`030</K00LK00B;003f2A/00`3e6`076`03F`0000H000=K6a/01A/00c/0F`0;6`03
R`0000<000<<6a/01Q/00c/0000300036l/000@000>;6a/01a/00oD0000>0000K0000l/K6`076`@k
00@KR`2;21/00e/000020003ba/K00LK0P0@6`03>`0000X000<<00000`000c/K6`086`03m@000080
00<k6a/01Q/00oD000030003Fa/K00HK00B;000<2A/200TK0`096`03300K00PK1C/011/003/76`03
>l]K00/K00=K000010096`033000008000?e00000`000c/K6`086a40001/0003mA/K00`K00=K05/0
21/00e/00002000331/K00LK0P0@6`03>`0000l000<k6a/02A/00``000020003>a/K00HK00<<0000
0`000e/K6`066`04R`00m@TK0P096`<02A/00l/<6`0>6`8000?f6a/01A/2F``K00<k000010086`03
>`0000P031/A0000K0000oDK6`0<6`03F`2;00PK00=K00000P000``k6`076`03b`0K014K00?;0000
30000c/K6`0:6`D000<k6a/01Q/00oH000030003ba/K00LK0P000``K6`076`802A/30003mQ/K00HK
00>;01/03Q/00l/0b`086`03>a/K00XK00=K000010096`03b`0000H03A/A0000K0000``K6`0<6`03
F`1K00PK00=K00000`000e/K6`066`03m@0k018K00?f00002P000c/K6`0:6`03F`0000<000>;6a/0
1Q/00h/000030003ba/K00HK00Dk0000>`086`802A/30003Ra/K00HK00=K03/03Q/00l/0mP0F6`03
300000<02A/00l/0000500dK00?f00003`0006`000<<6a/031/00c/0b`086`03F`0000<000=K6a/0
1Q/00e/0R`0C6`03300000P000?;6a/02a/60003Fa/K00HK00?f00000`000oHK6`076`<02A/200TK
0`000``K6`066`03>`0K00hK00?e00005Q/00``0000300TK00?e000010000oHK6`0;6a80001/0003
31/K00`K00<k0?H02A/50003Ra/K00HK00=K05/04a/00e/0000800dK1`000oHK6`076`D000<<6a/0
1a/30003Fa/K00HK00?e01/021/3000331/K00LK00<0>a/03A/00e/0000=6`03mQ/K00HK1P000e/K
6`066`03R`0000@03A/C0000K@000e/K6`0<6`0300`K00PK1@000e/K6`066`03F`3f00PK00?e03/0
2A/00``000060003mA/K00XK20000l/K6`076`D000<<6a/01a/30003Ra/K00HK00?;08/021/01</0
00`96`0303/K00dK00>;00003A/00l/K6`066`03b`0000<000>;6a/01Q/00h/000030003mQ/K00XK
00<<00004@0006d000<k6a/031/00`0<6`086`033000008000>;6a/01Q/00e/0b`086`03R`0000TK
00?f00001P000h/K6`096`T000?;6a/01Q/00c/00003000331/K00LK0`000e/K6`066`03b`1K00PK
00Ce003;2A/00`0k6`0=6`03F`0000dK00?e6a/01Q/00l/000030003Ra/K00HK00?f00000`000e/K
6`096aD0001]0003>a/K00HK00Kf3?GeboD20003>a/K00HK00?f00000P000e/K6`066`03R`3;00PK
00B;003;21/00h/000060003Fa/K00PK10000`cf0003000331/K00LK1P000c/K6`066`04m@00mPPK
00<k05/021/01</008/86`03>`3f00PK00<kmX/00h/00e/0000<6`03m_DK00LK00?;00000`000l/K
6`066`03>`0000<02a/40003R`0000l0001]0003Ra/K00HK00?;00001@000e/K6`076`@000<k6a/0
1Q/00oD030096`<021/00c/000060003Fa/K00LK1@000a_;0003000331/K00LK1P000c/K6`066`04
m@00mPPK00=K0?D021/00e/000096`03>`2;00PK00>;00001P0<6`;e21/00h/000030003ba/K00HK
00=K00000`096`03>`0000<000<Km@003`0006d000>;6a/01Q/00l/000050003ba/K00LK00@<000<
2A/00oD000096`8000<<6a/01Q/00e/000060003Ra/K00HK00?e00000P000e/KmP0500TK1P000c/K
6`066`04b`00mPPK00=K0</021/00h/0b`096`03mP3f00PK00=K00001P000e/K6`096`8021/00h/0
0003000331/K00HK00=K00000`000e/K6`066`03b`00008000<k6oD0400006d000>;6a/01Q/00e/0
3004308000<k6a/01a/20003>a/K00LK0`096`8000<k6a/01Q/00c/000060003ba/K00HK00Dk000<
>`026`03b`3;00?e00<k6a/01Q/00oKem@02m@0305/K00LK00Cf003e2A/00`3e6`076`03>h/K00TK
00?;00`021/00c/<3005300303/K00XK0P086`03R`0<00Ce2A/01/_emOD0R`PK00EK0000>`026`03
m@0000h0001]0003mA/K00dK00<<08/05A/300TK00?eFa/021/00e/0000700XK00=K6a/00Q/00l/<
6`0A6`0305/K00LK00Cf003e2A/201@K0P000l/K6`0>6`0308/K00TK00=K000021/00c/0F`0A6`03
F`0K00TK00=K6a/00Q/00h/0000>0000K@000l/K6`0=6`<051/01?H0000D6`03mP0000L03a/00h/0
6`0A6`030?HK00LK00AK003e2A/201<K00Cf000<41/00`3;6`096`03b`0000PK00=K08/04A/00c/0
6`0>6`03mP0000h0001]0003mA/K00dK00@<003f4a/401@K00?e00001`000l/K6`0<6`03R`0K014K
00<0ba/01a/01E/0000k00PK0P0C6`@041/00`3f6`096`<021/00c/0m@0B6`030?HK00dK00=K0000
3P0006d000?e6a/03A/01?D0000B6`03R`00008000=K6a/041/00c/0000900hK00=K01/04A/00`3;
6`076`04>`0030TK0P0B6`03m@00008041/00`0<6`086`04>`0000TK00<0mA/04A/200lK400006d0
00<<6a/03A/00oD00002014K1@000e/K6`0@6`03300000T000<<6a/02a/00c/<6`0A6`8<21/01C/0
000k00PK00?e01/041/00oH00003010K00<<01/021/01H/0000k00LK00<k0?D04Q/300dK00<k0000
3P0006d000<<>a/03A/00l/0000300lK1P000h/K6`0?6`03m@0000/000?;6a/02Q/00e/0F`0A6`03
300K00LK00Dk0000F`086`03b`1K00lK00<<0000100@6`0300`K00PK00Ge0000F`086`03300K014K
0`000oDK6`0;6a00001^0003>a/K00`K00?f000010000e/K6`0:6`03300000@000?f6a/03A/00e/0
000>0003mA/K00XK00<0Fa/041/00oD06`076`05>`0005/021/00oD0F`0=6`03mP0000H041/00l/0
6`086`05300003/021/00``06`0A6`@000?e6a/02Q/@0000KP0?6`03R`0000D000?e>a/01a/00oH0
00060003Ra/K00XK00=Kb`004`000h/K6`066`03R`00018K00>;01/021/01?D003/86`03>`0K00XK
00>;b`002@000c/K6`0=6`03F`0K00PK10000oHK6`066`03b`0K014K00?;00000`000e/K6`066`03
R`0000l000280006mH^;RoH<;`001Pb;Rh_f38X000KemX^;mP`C0000o`1W0000o`1W0000B@001aV9
RG[f6nT00XT00fT<00050003f_l000D000L<RHVYRGZ;008k00?iRJT00hT00a_f:P02R@03JOH000<0
00D<bFUYn@02>`0?mXVYJHT0NQVYJKZ;>oK900:900<Y00000`001_IYJHVY>`9K00EjRJUYZ@030009
n_RYJKYK>h_Y00:900UYF`0Z:JUYfU/00c/01a/k6c/K>a/00c/01=X<02X2J@03^X/K009Y00>9b`00
10000g[o00040005mJUYJOT00S/00oJ9Z@03R@08ZMZ;NVV96OD5000>^8V9jC^;n^V9JNT06fT2R@09
:_Hk>gYYZOQK00H000bYJHVY^X]Kf/V9ZKP70003NZSo00Go00<YNP000P002OEXbO[;:VVY^00600=Y
00PZFe/kbHUYj@l0001900[o00<K000010000aWo:P050003booo01;o00=j00000P000oGoo`09o`03
0?Wo00[o00=j00000P000c_oo`0:o`<000?Yool02Ol00oT06@0Co`03J03h00So00?J00000`000`Wo
R`040003m_oo017o00<k00000`0;o`030;[o00[o00>Y0000100<o`D000?Jool00_l01FWJn[YX00Co
00<Z0?l01ol00c/0000300_o3`0004`000CJoooh2P000jSoo`0:00Go00=Y00000P000fWo6@0<0003
bOoo00;o00?e00001@000oSoo`02o``000=jool00_l00kX000080003Z?oo00;o20000a_oo`02o`03
>`0000L000Chooo;0`000k[oo`090003^?oo00P000?eool00_l00oH000020003n?mY00`000>9ool0
0_l00c/000050003JOoo00;o00<K00002P000h_oo`02o`03:@0000D000Gioooo^00700Co00KJ000Y
ofT<0003ZOoo00;o00?;00003`0004d000>holX02P03o`03NP0000P01?l00oD000030003ofT000/0
00EjooooJ00800056oooooT03@04o`/000F;oooo:@0900046Oooo`/000>hofP01002o`T00ol00h/0
000600046Oooo`H000?oJ@002`001G[ooooY00T00ol00fT0000<0005f_oookX01P001L_ooolY00T0
00AXoomY0`000onY000;0005N_ooofT04P0004d000?folT02P04o`X01?l00oH000030003ROl000/0
00DYoooo^P080005m_ooobT03@001FSoooof00/01?l90005ZOoooc/02`02o`0630000;[o2@04o`P0
00B9oooo1P000g[o300;0005ZOooomX02@04o`03mP0000/000Gjoooon@0600Co2`000kSoo`030003
ROl<00/000EYooooF`0B0000C@000`co2@0:00Co00=j00001`04o`036`0000@000?oNP002P0016So
ool:0004J?ooo`d000Gioooo2`0;00Co2@001G[ooomj00`00_l40003ooX000H000?fool00_l00h/0
00050005nOooooD01@000`cof@0;0005Z?oooe/02@001FWoooo;00d000F;ooooJ@050005m_ooooT0
3002o`06b`000?mj2`001?SooolC00001P000``03002300300`<018<;P000kSo00080003b_oo00;o
00=X00001`001FSooomj00H000<Io`002P04o`X000Choooo3@001G[ooooi00/000AXoooo2@001L_o
oomY00`000?jo`000`000olY00060003f_oo00?o1`001K[ooon;00H000=Yo`002P03o`03Z00000P0
00Gioooo6`0=0005mFSoojP01@001FWoooo;00d000?oJ@000P000oSo00090003m_oo00;o4`0000D0
0P`4m@04boGeb`Ke00?;mOD00_D00l_eb`02m@<<;0000m[o>`080003jOoo00?o00>j00001P001HWo
oooi00L000?o6`0020001O[ooooh00X000Choooo3@001L_ooomY00/000DIoooom@0900?o00>X0000
2`000h_e00020003ZOl000H000OioooojOlZ00H000EKooooNP060003m_oJ00T000GeooooJ@0:0005
n_oookX03P001?Soool500?o00=X000030000lWo00020003bolk00T000GjooooJ@0C000010023003
boKf00Of00J;mX_fRoH7R`?f0_D232X000?;obX020001kSooolIJOl020001HWooomY00L000>Xo`00
20001B[oooo900X000GYoooom@0=00?o00=X00002@001OWooolK00T01?l70003300000P000?;o``0
1P04o`030>Wo00H000G;oooon@070003J?l000P000GJooooj@0:0005boooogX03P0018Woool500?o
00?h00003@000c/000020003J?l000P000EjooooNP0C000010000`c;mP0HF`:;00Cfbl_e0P`X0003
okP000L01?l017X0ogX70005^_oooaT020000ooe00070005JOoooh/02P001K[ooooj00d01?l;0005
>oooooT02@04o`H000?;^?X02P000omj000500Co0P000omj000500?o00=Y00001@000c_oF`080005
ROooomX02`03o`03R@0000`000C9oooo1@03o`03n000018000<ko`0020001HWooomK01<000040004
3<]KFa<k00AK>c/k0e/2R`04m/_em@<<90000nWo300700Co00CJ01Wo1`001A_oooo800P00_l00l]K
F`03F`03RoIX00?o2`001A_ooolZ00d01?l;0005mOooofT02@0016Woool60003Rooj00X000?hJ000
1@04o`8000=Yo`001@03o`03Z00000H00_l00c^;F`03F`:;1?l00oH0000900?o00<Y000030001K[o
oolk00@00ol00nP0000C00;o00?fFe/00e/00h/kJ003o`03m@000140000300033?Gf009K2C/00e/k
>`0>>`=K0X/00oK;m@0232<000<Koa/01P000oGoo`02o`056`2;ogX01`03o`03^00000L03Ol;0005
mOooobT03@001?Soool<00Co2@001B[ooolk00D000=KokX02P000g[o00040005>ooookP00`000omj
000400Co20000k[oo`0:o`03^00000X000FhoonX300=0005f_ooooX01003o`036@0001<000<Kool0
2_l00fP0000B00000`0010cemU/F>`03Fc/k00@k15/018_fm//2m@8<80000onY00050005N_ooofP0
0`000oSo000600Co00?;00001P02o`030?Ge00;e00<0^_l00_l00bT0000:0004J?ooJ0d000Ejoooo
nP0;00Co2@001K[ooonj00D000>;okX02P000oKonP040005:_ooolT00`000lWo000400Co2@001?nh
00`2m@8<00DkooooJ@0<0005JOoool/03@001OKooomY00@00ol00fP0000D0003ofP000Ce00<0n_l0
0_l00hT0000B00000`0010c;Re/<>`03Fc/k014k15/018_fbl/2m@8<7@000aWo000500056OooofP0
0`000h_o^P0600Co00?;00001P000c_o00050005N_ooogX030001;Soool=0005N_oooe/02`0018Wo
ool90005mOooobT010001<]XobX;0003J8T000<000DYoooob`0300033?mj00@000BYoooo2@000oWo
000500056oooooT030001NWooomK00d000GeJ?oo:@0400?o00=X000050000b[o00050005N_oookX0
500000<000@<bh]K53/00e/k>`0<>`AK00F;m/_;m@0331X000=joe/01@04o`03J@00008000>Xo`00
1@04o`03nP0000L000?oJ@0010001HWoooof00`000AXoooo3P0Co`03300000L02ol00jT000090003
bOl000<01?l50003bOl000<000EYoooob`090003ogX000@000FYoooofP0<00056ooookX03P001?So
ool400Co00?f000050000omj00040005ZOoooc/0500000<000CemU]K2S/00e/k>`0I>`=K00F;m_K;
m@0331T000?o^P001004o`03j@00008000?fomX01@04o`03^P0000L000?:o`00100011Woool=0005
:_oooe/03@04o`03^^WY00KY00?9NRT00ol00kX0000700Co00D0RoZYJ002o`03^00000T000<koe/0
0`04o`D000?eonT00`001G[oool<00T000>9o`001004o`03R`0000X000EKoooo^P0>0004JOooo`@0
00Ejoooo:P0F0003N_l000@000Ghoooob`0D00000P000`cemP02FaHk00=K>c/03c/01E/kFe^;00;f
00?;m@`00P`F0003Z6P000<000?;ool00_l00e/000030003^?l000@000G9oooo^P0:0003ooT00080
00?fool00_l=0005N_oooc/03@04o`/000DKooooNP0900Co1@000e_oZ00<0005ooT001/00ol00fP0
00040003bOl<008000DKooooNP0:0003olX000<00ol00kP0000;0005mOooofT03P0018Woool500?o
00?h00005@000olK00020006boooojP<5000008000@<bh]K3C/00e/k>`0K>`03Fc]K009K00F;m_K;
m@0331<000?iooD00`000g[oo`02o`H000?;olT010001FWooon900X000=jo`000P001E_ooomY00d0
00EKoooob@0=0004J?ooo``00ol00bT000070005ROoool/01@000oWoR`0;0005JOl00;X00ol00lT0
000400033?oi008000GJoooo:P0:0003JOl000<00ol00bT0000;0005boooojT03P001K[ooolK00@0
0ol00fP<000E0003ZOl0008000G;ooooZ@0E00000P0010c;Re/_>`AK00F;m_K;m@02314000?eoc/0
0`000nWoo`02o`L000<Yo`000`001G[ooonY00/000Goj@00^P03o`03NP0000/000D<oooo:@0=0005
:Oooo``02`03o`03J00000L000FYoooomP050003^_mK00/000GJoh/0R@03o`03NP0000D000>Yo`00
0P03o`03f@0000T000Gom@00nP03o`03j@0000`000DIoomX300=0005^_ooomX010001M[ooomj01L0
00GofP00nP03o`03NP0001<000020004mOIKF`/k00=K>c/01c/00e/k>`0I>`04Fc]KF`:;00CfboGe
0P`?0003ooP000801Ol80003ohT0008000DKoooo^00;0005N_l00>T00ol00oH0000<00Co3@001G[o
oooj00/01?l900056oooobX01P000omj000;0004obX0Z0?o00?e00001P001?oi0003o`03J00000T0
00Fho`00J@03o`03fP0000`000DYoooom@0=0005mOooocT01@03o`03n00001D000GYo`00j@03o`03
6`0001<000020004mOIKFc8k1U/2R`04m/_em@8<30000lWo000200Co00>900001P000bWo00020005
RooooaT030001?oJ02T3o`l01?l=0005f_ooogX02`0016Soool90005m_ooojT01P000oTK000;00;h
00<0J?l00_l90004JOl000?o00=X00002P001?l<0;P3o`03b`0000`000GiooooR`0=000536SooaT0
1@001OWooooj01L000Com@3h0ol00e/0000C000000D03<^;F`0>>`03Fc/k00<k00EK>c/kF`0J>`03
Fh/k008k15/018_fm//2m@03300<00P000>;ol/00P04o`03^P0000L000?oR@000P03o`03J0`000X0
00AYo`3X0ol?0004J?ooo`h00ol00aT000090005:OooooH02@03o`03Z000018000AjJ1]X0ol:0003
ogX000Co3002J0050?ooofP03`001K[ooolk00h000Bhoooo1P03o`03^00000/000=KJ1/01`000fWo
0003o`03Z00001@000001@3ebh]K020k00=K>c/043/00e^;>`06>`=K00F;m_K;m@0330L000CoR@3J
1?l00h/000070003:Ol000801?l00l/000090004booY6@;o00<I00000`000hVj00070005jOoooh/0
20000nTk000200?o00>X00002@001G[ooonj00T01?l<0003NP0000H000=X^6P00_l00kP000080004
:Ol0^0?o3@000ol0o`02o`03^00000<000=jj@001`001C_ooonj00P000<Kj@000`0011Woool60005
6oooogX030000o[o6`080003oe_o00;o00=Y00005000000300c;009K33/00e/k>`0>>`9K7c/3F`:;
00CfboGe0P`50004JOl0b@Co2`001?mY0004o`03>`0000X000>Yool00_l00nT000030003JOl<00L0
00EjoooonP070003mOoY00<01?l;0005f_ooobX02@04o`/000=Yo`001`000fWoo`02o`03n@0000T0
00?omJT00ol=0003^?oo00;o00=Y00000`000b[ofP070005RoooooT02002o`@000Aioooo1`001FWo
oooe00/000>jooX020000bWoo`02o`04j@00fP9j00?;00003P0000040?GfFa4k00AK>c/K0c/01`_J
f_XKfWX00RX02KYZ:XIIHS]K6`0G>`EK00>;m//00_D2308000?fo`001Ol;0004:Ol000Co00<K0000
2P000l_oo`02o`03nP0000@00_l70005FoooolT01`000jWom@0300Co2`001OGooonh00T000DIoooo
b`090003n_oo00P000=jool00_l00gX0000900036Omj00?o00?;00002`04o`03^P0000@00_l00c/0
00040005mOooofT01`000e_o:P040005:_ooomX01`001:Soool;0003JOmj00T01?l01KX0N_lk00;o
400000043?F;F`lk00Gj:RYF:P02j@07QhJ6QXNa;@04Q`8]0hL01h00b`_JbP/05c/4F`:;00SfboGe
303o^PCo00>X00002P001?mY0;P3o`03NP0000/000FYoooob`060003jOoo00L00ol00aT000040004
Fooom@<000EYoooomP0;00Co2@001FWooomK00T00_l00jP0000600036ooo00;o00<<00002P000olY
o`02o`03nP0000/01?l00oD000040004^_ooF`H000CXoomX1`02o`03fP00008000Fjooooj@080004
Z?ooo`T000@<oomj2@0036Woooo;02WYZHTZf@l0000010c;Re/>>`04FfZ7;A>700<]JP0010001@cf
>`/K01Hk15/01X_fbl_eJ@Go00?Y00002P0016So06T3o`03:P0000/000F;oooo300700?o00>j0000
0`04o`D000CjoomX1004o`03:@0000T01?l00e/000060005n?ooooP02003o`03J@0000H000>jool0
0_l=0003J?oo00;o00<I00003003o`P00ol00jT000030004^?ooo`D000GfJ?oomP040003:_oo00;o
2@001JWooooJ00L000AXooo92@0010coofP20006jG[iol/I3`0000043<^;F`lk00=ZQhL04hL01;5E
000230<000?eR`/00/XG>`AK00>;m_X01Ol00bX0000;0003ofWf00?o00>Y000030000fWoZ0080003
JOoo01;o00B9^^Ui1ol00bV9nP030003bNUX00Ko00QXJJW;0?VYZ0Go00MXoomXROTY00Co00=j0000
0P0010bYRFP5o`d000?eool01?l00bV9^P0:0003J?oo00P000?9ool02ol00fSoo`05o`0500bYRKP0
1ol00oVY00050006>fSoojRj0P000oEjo`04o`X000=Yo`T00P001QWo6bWo30l000000oGfF`0@>`03
P8N700F700<]QhL01HL00bf7Q`03Q`03;OX0008000D<00`030040005bc/;nQ/01c/00e/k>`0;>`=K
00>;ool00ol00oD0000;0003J?lK00?o00=Y000030000oKo6@080007mOoo:ORhb002^0<Y00MY^<Rh
b;R900;o00Kif_oo^6T4:@04^?ooJ@<000AXoolI1BT01JSooc/000?o00=Y:BT00RT01KS8Z?Rh00Ko
00?e00000P002L_ooomY:FWoJ00>0009:OohJBVhJ?lI00/000?oJ0002002o`06:AVX^<Rh12T00oRh
b002^0042OSoo`8000AXoomY0bT00fWhJ002o`P000<KZ?l01_l01BX001_e00T000?fokP00`0017[o
^5/@000000?emU/043/00h2aQ`03Q`03P8IR00>600ERQV9RJP05Q`03;F/000@<00<030000P`30006
3<^;2lXK5S/00e_oo`03o`8<3@05o`03j00000d000?e000020000fWj000@0003bGX000X000<<0000
0`000``000070005300000`0=0000``0000:0003b`0000P000=YfP0040000e^h000<0003300000T0
0_D00l_e300@0003m@0000<00P`A000000?;Re/03c/00a^6;@02Q`07QR]RQX26P002EP04P8N7P0J7
00C;000<0P03300400`<30H000Ke2l[:2a/>>`=K00?iool00ol00oD<000<0003^?oo00?o00=K0000
m0000003bh]K00lk00<KQhL00XL01hJ0QhJ0JXL00f800nYZP006Q`03m@0<00<<00D0300<00033003
00`<00@000D<be/;F`0;>`04FoWo:@Oo00?e00003@07o`036FRj0?8000000oJ;>`0>>`0:FmZ7;HNa
HP3eb`9[00R;b``<J`3j/@B700N6000<00`000<<00/03000^S/0300<000230<000H<>mZjbQ/7>`04
ROooo`=X0_l00oSe300>0004n?oo^09X00CXoooolP000003mU/k00lk00=FQhL00XL03UH0mR]EP6_j
JX1REF:a18L01H0000`0008<00<030000P`0103e^_X2000335^;00P000D<bc]K6`0<>`9K00?f3000
o`0;000000>;Fe/03S/00e]ZQ`04Q`03/Bd]00:700Fa;Bf7;@06Q`04;EH000<<01@030`<00`0mLXK
00`k:WZ;35_f00<<0`001_F;6m[:6`Tk00>;m_D0o`0<000000>;Fc/03c/00h27Q`0CQ`06/NX000`0
0P`00`0<0002300B0?GJnP3ef_[J2`3J6oDKm@0<1`001OKjn_XK00Dk00>;b``0o`0<000000>;>c/0
3c/00f8]Q`0CQ`04;B/0008<00H030`<00`20006mOYjFl^j0_H00k[;6`026`09N_H033^;0?D<00<0
00H<Rc_Jb_X2>`04Fh_e3?l03000009K43/00hJaQ`0DQ`09mP0<300<00`000<<00l03=ZjFl^jm_Fj
Rc/KfU/00P002<]jN_D0Rl/<1P001`aKf]XKmP`0o`0<000000=K>c/03S/00a^6Q`0EQ`05m@0<00`0
0`0010`030`20005NU/0mGX00_D01[[;6mYjm@8000_;m[Xk0;X;0?EKm@0230<000KeRc/;F`co00/0
00000e/k>`0>>`03nXL]01B700>630000P`01@3e000<00@0010<^]YK37[;37[efQ_JF`0<0P02nP0:
0;Xk01]jfPc;mP<<0`001PaK6c^;mOl01`000003Fc/k00Xk00EK>c/k^P0FQ`04HP00308000O:onT0
mP3e008<00CJN[X00]X011^j3=X2R`0E^P0<03]jnP2j>`2jnW[;Rg[J0?Gf008<0`001Pc;>c_;3?l0
1000014k00=FQhL058L026X0000<0?HZ0X/04^We^^W;00aK00aj^]X0nQ]KNP8000ge^[[f3;Xk0;[f
6e_f00:j00IKmKZjboH2m@@000EKf_XkmP3o00400002F`04:c/k>`9K0c/01e/kFc]K>fX05HL012eE
0002300G00cjm]YXfS_oZ?Qj03]KboH03=Yj^_X00P004L]jmP0<fS/<^X]K6oKJFmX<00:j00N;nS_f
>`c;00@000KemU^;b`cl000000BUFJGY2ZD00bUYK00FQ`04;OX0008<0P005K[;N_mj08Vjf[X0RFT;
fS_;3<]Kb`020003mK[j00;;01SJ>`cJFc/;Ro[;f_KJboD;>a_J3?[fmL/43003mP/Z00`Y00<i:BT0
22T2>@03:CTY00<Y00<I:BT02BT00`Wh:@05n008:ATI>OP9n3T2:@9Y00HY>OSh:KP52@09j0Vh2NRh
j;RX00>h00C8^:Rh1:P00kRXZ002Z003V6RX009X00bXJ9QXZ6RXJ:QXV6P2V003Z9RX00FH00LMV2TM
n2T900<I0PT01_PM2Ad97@8900LI2BTI:AdI00@M0`T00oPI:@02:@03>BTi00Pi1BT01_SXj1WX:@?X
1BT01>Shn0T2j0032BT9008Y0_P00bWhn002n0?X00?h2NP01OP01mS8b<SXZ6`00/P00nS8n002b003
f<S800;800RXb:S8Z<RXb06X0005Y@03QZF700JU00DYJBV6;@0DQ`04;F/0008<0P005;X06CWJ0:PK
N_H06MT0JJT0N^Wf0_D20009FgXk>k[jm_Z;008k00QK6h_JRmYKb`8K00Cj6oFj0X/012[f3</23005
be/Y:CT03RT00cTY:@06:@04n3TY6@<Y00?h:BT01bT01PWh2OPYn0<Y00D9>OSh>@022@036FUY009Y
00@Y6OSh0RT62@04^2Vhj0:h00?H^>P01;P01JRh^:Rh00>X00FhZ:RXV002Z007V:RXZ9RXJ002V0FX
00>HZ9P00iP02`Vh7BTI2BTIJATi008I00D9f2Vh7@032@046@UI6@8Y00<M;Ad010T01BWh:CTI008Y
0cT012Ti>CT7:@?h00DYj>SX6@02j0HY00KXn>SX2OP4j0042NPYj08Y00KXn>PYj0T2j0032OSh00;h
0/P03=S8Z>SHK<SXb=Shj0W800>Xb:P00ZP00006JJFUYNVU0^T6Y@05JBVUQRd05HL0://030`0300Z
0?mKNP1XFl^9^VPk06Sj05_oN_YYNQ/0m_Gff[XKfX_jF`8k00MK6e_J^X/k00;J00lkboZ;m[[j3?D<
mR[9:CT032T01OPin2Wh00@Y00Hi:OPi:OP<:@8900PI2OP9f?P96@8Y00D96ATin002>@036FUY008Y
00<In?P00bT01PTY2@Vh:@Bh0_P01;SH^?P4^003Z<RX00>h00>X^:P01jP00iRXV004Z005V:RHV;P0
0YP03KRH7IPM:ATY2BTIJAT00ST01AT96OPM00D900DY6BUI2@02:@037@T900<90RT01aTY:CTY>BT0
0ST6:@05n2Wh:OP00^P00aWXj003j0<Y00@i:OSX0oP2j0Oh1>P00`WXj002j0?h00K8j<SXb=P2b007
K:S8Z>S8j002n0W800>hb<P00jP00003JJFU00:U00?YYNT00ZD02EVUYJDYYEV6/@0EQ`04m@0<008<
01406`_o0<X<o``0NR[om@1XfP020007Z?H0oe_J6@02fP0ARl_;boX<nX/kfWXkFo[fba/00]X028_;
fX/0Rm[;0P`00h^jY@0C:@036BWh008Y00dI:BWh>BTI:ATYn2Ti00<Y00?h:@T010T00oP9n0022@8I
00<i2OP00_P00aUYJ@02J@05:@Wh6OP00RT32@03:@Vh008Y0_P01[Shn?Rhn0>h00[8^;SHZ=RX^:Rh
2JP02;RHZ:RHZ9Rh0iP030VH^0Wh6BT96BTIJ@8i00QY>ATI2AdY^0<900TY2H8Y>BT97BT010T2:@03
6CTY008Y0ST::@03j2WX00CX00HYj>SX:AT4:@06n>SXn>S80oP00mSXj003j007n>Shj?SXn007j0K8
00NXK<S8j?SH00?h2<P01:S8Z<P1Z00000<iJJD01JD00nVUY@03Y@03JJEI01J700>000000P`0100<
0</2J00405_jo`8000?j^[P00P001KRj003o008000oom@3o>gZ9^?K;33_fmE/00[X04ODk^U/<bQ_J
FoFjboFjb/_e00;;00CfnCTi4RT01oPY:OPin1T00RT02?PYn2Wh>BWh12T42@;h00?Hn?P00`T021Wh
n?PY6@TI0VT012UY2AT2n0032BTY00DY00Ch^2TY0_P01KShn;Sh00Bh00?h^=P03KP2Z0:h00NX^;Rh
V;P900:H00<M^1d00PT2:@042BTI6@9Y00PiJBTI2OPI:@<90RT2>@086CWhn0TY2BT22@056@TY:CT0
2bT01^PY:AWX6@?X00@Ij>PY0^P4:@09n>SXj?SXb>Sh00;X00?8j>P03>P01<SXb=P3b003Z6cH00C8
00Ch2OSh1<P00oS8b004b0>X0002J@>U0^T01hJTYJEIYET00jDEQ`07;H0000`03002000IRooh0?DY
^</0nZSi0</YNP3;oe^;b8/<o`0200:j00P0JL/ZRKZ;mP80014<>g[;^U/;FoFj31]jR`ceb`02m@04
bBTY6@<Y00<i:BT032T00aWhn002:@07>OPY6BTIn003:@06>BTY:NP90oP01^Shn?SHn0<91_P01BUY
JFTY00<90_P5:@07^?PM2ORhj002n00=j?Rhf?Rhn=Rhf;SHn004^003Z;Rh00Nh00fX^;RHj0VhV0Vh
2BTI00<900<IFBT00fT02SUY>CUY2AWXn2T32@036CTY008i00@96NSX0PT01>PI2AT@:@cX1BT01OSX
n<SX00?h00?Hj<P01nP00lSXb003j004b>S8j0?800?Hb<P00ZP4b0Ch00?Hj<P00lP00nS8^003b0:X
00000jIYJ@03Y@04jJGYQPJU5XL012fj0003308002OiojT0mFVhb`1joc_emVUj01]X:ZUXmX]XmQ/0
f/_ojE]XbBX0JBX00S/03U_en/_j6oYjRoXk0?G;0_D01L]I:BUY00DY00=Y6BT00RT01ATY:BTI00DY
00@i:AWh0RT3n004:AWhn08Y00?h:@T01?P01mSXn=SXn=P00oP01^Rhj?Pi6@9Y00<YJAT00oP2j08Y
00Bh:OPY0oP012Wh^?P2^00<PYmNf?SH^?SHn;SH0kP00mRh^003^003Z;Rh00Jh0YP00`VH2@027@03
:@TI008i0RT00cTYJ@02J@06>FTY6@TI0_P01>PI6AT2>@03:AT900?h00CXn?PI0PT>:@?X00<Yj>P0
1NP012WX:NP5:@?X00Khb?S8j<P3j005b>SXj<P01>P2b003j<SX00;800cXb:S8Z<Q/Z<SHb=P4n0;8
00Ch^<Sh1<P2Z07800001SUYJJEIY@;Y1ZD00eVUQP0EQ`05;NX000`00`001<]j:X/2000GnKSe0;[9
bg[ejGX0fQT0FjSj>fR9b@000U/03VRjbhT0>l_h:S/Y3?Hk0``01h/k2h^j>oD00//00oJ;:@03:@04
6FTY>@8Y00UY:BT9>BTi6CT01RT02ATY:OPYn3TY6@02n005:OShn>P00oP01nRhn>Rhn;P00_P01^Sh
^=Shj0;h00<9JFT00RT010Whn?P3j008^2Whn>Sh^2T2^009:KShn8:OG]Sh00?H00Jhn3F2^?P3^004
=H:hf0Nh00d9V;P9V0Vh:@TY2CUI008Y00@i:FTY1FT00cTY2@04n08I00LY>BTIj?S800Ch00CX2BWh
3bT:j003:NPY00@Y00ghj>SXb?R2=OSXb>Sh00KX00?8j<P00^P01<SXb>P2b004j<S8j0:X00I/b<S8
n=P3n0K800Fhb<RXb002Z00000>VYCT01:D01^VUQ^VUQ`>U00>6;HL04hL02K4[000<0?G;F`026`0;
F`00^_n9mL_f08T00QT03RXKRCWfFaWjNVTZ^P2;0XT08?EjbOIjnVWe2nP06olZm_SJRe/<^P/<mL^j
NSTY6FTi1bT01ATi>BT9008i00DI:BTY>@04:@03>BTY00?h00HYn?Sh:NP2n00Ef?SHn>SHb;SHb>SH
n<SX^>Rhn3TY009Y0PT2n0GX00^hn>Sh:OPYn0Wh7@02^007PYmNn;Sh^002n003^3De00>h00CH^3De
2kP02iRhV;P97OPI2CTY008i0bT01VUIJGUIJ@@Y00HIn?PI2AT3:@032OSX00Ch00<9j2T02BT00f`Y
:@05:@cX12T00oSXj002j006b8:O>LSX0_P9j003b>S800;h00?8j<P00lP00jQ/b004b0?h00?Hb<P0
2LP1Z0780JP00004K:DiJ@BU00CYYNVU0^T01:GYQ[4DQ`0>;OH0300k:ZPZRGXZN_D20003b``00080
00Ofn_[9ZBVX009K02Gh>k[YboD0FoRjmVUjm^UXb@1jb@0k^WYYf_UYfPc;mL/<bb[Y008Y00QY:BTY
>FTi6@@Y00=I>BT00cT00aTY:@02:@06>BTi:CWh0RT9n0052OShn;P00nP01OSXj;SX00:h00K8^?Sh
6FT2:@06>OShj;SX0[P02NRN=OPeW[RN=@02^00AGSFhPYleWikhPYmMn8:O:MP00kP00efO2@05^00?
GSFH2CENV0VhGSD9PSDd008i02<Y=3DYPSF2FCBOJCTI=IhIPSF2>BV2WcF2f9hen88eP_PeWP02:@07
YSFN=Ihi=@02PP05=CVN=NP00SD2j00=WYn2j9jO=F`Y=Ihi=@02PP03=CW8008e00GXb>SX6@02j005
2NP9j0T00^P2n0;X0oP00lSXb002b006Z6bXf<SX0_P7b006Z<S8b:S80ZP00005YSTiJET00ZD01>VU
jJ@2Y@03Y>VT01N700Se003f>HWJR@:j00B9n;[e0P0430<001?eRe/Zbb[onSWomWX<^_l;RfSJ0080
019Y^P39:P0;jFVj03]YRm[o:P02b`03>nTY00@Y00Hi:BTYJAT3:@8i00@9:ETi0QT2:@05>BTi:CT0
0RT01?PYn2T2n003:OP900890oP01^Rhj>Rhj0:h00Khj>S8^>P2n004>ATY:@;h0kP03>Rhj>PeWkRO
=KPeW`:h00@eWkR219l020VNWijhj9mN0kP01JRhWejh00:X00^hZ9nOGEjO=KRH2@02W`04PUjO=@<Y
0Yl01H8dWcEI00:O00>2>H800Yl01PTeWihI>@BO00[h=IoXWYn2:Ile0RT03SFOWilePYnNDYn2=InV
0Yl01:J2Wil2PP0@WcFO=BVO=H:O=5jOP^R2W`?h00SXn>PYj2Wh2@;X00Chj?SX0_P00`Whb004b004
K:S8K0;800CHb<SX2LP4Z00000VU>FTiYEVUjJ@00ZD01hJTjJF6Qbd058L028H000b9bOYj0P001_EK
nFWY00H<00?e30`00`006``008_JbGYXboVXR`coR`2jZ3/0RGX06nTI>`02000;>h]jRE/<boD<:QT0
12T00fTY:@08:@8i0RT01AUY:CTY00<i1RT00oPY:@02n006j?P92OSX0_P02nShj;Shj;SX^>Rh00;X
00ch6FUY:@Wh^<RhZ>P2^008=IoXWcFh=Il2^00;=InhGImNPYmN:Ed00^P01KQNWkRX00>h00=NWjP0
0[P01ZQMWimN=@:O00>H^5d00Yl01iheWimY>H800Yl01c@eWimYRH800VT019jOWh82W`0A=CUNWfBN
W`TeWnRNWh89WcD00RT01ile:IlePYl00S@089n2=IoXPSWX=Ilij3FOYSFO:IlePYmNWYn2j?ROG_SX
1@T00nPY2@022@06j?Shn0WX0oP02>S8b>RXK=S80^P2n0?800>Xb<P01<P01:S8Z<P1Z00000@iYSTi
1JD00hJTj@04Y1J700QR00aE:K[j30=j00HkFjQXmP063003m@`<00;e0P`300063=X;0>PZ0P005_mj
06UXF`3I:P0kbOPk301KN_lZ3?D3b`03bBTI01HY00=Y:CT00ST4:@04n2Whn0<Y00<96OP00_P01nRh
j>Sh:OP01^P03[Shn1TY6CTIn>Rhb;RX0[P03cFO^9le^3FO^:PeWkQMW`02G@0AWejhZ;RX^0VOGKRX
^:P9Wed00jP02ejO=CFO=ImM^5jO008e00NO=In2:IjO008e00FO=In2F@03J@0VWcFO=IleW`TdWfAN
Wh8eWkRNWh8IWcDYK9le:IlePYldWYn2=Il4j00Q=IoXj3FOj3FO:IlePYldGYn2b?RNWoP9j0WX2NP9
n2TI008900Gh2NP96@03n0;800GXZ6bXK002b003j<SH00K800BXb:S80ZP1b06X0JP000<i00MIYEVU
jJGY00>T00?YY8H00XL01Rfa;HL]Q`@]2HL04ReZ0?H9RH_;^]Yjf[X0RlUj00P<00Ge30`<m@043080
01Ce003;37[I0;YYmGXZN_DkJLUj008<00T;Z5/<mL_ebfT02BT00aTY:@09:@8i0RT01CTY>BTi00HY
00?h:NP00`T00aWhn003n005j?Sh:AT00_P00kSX^002n0046CUYJ@8I00Gh^;S8^002b00F^3FO^9le
Z3FOZ;PeWkQMWeiMWejHGP:h0ZP2=@:X00>HZ9P00SD2Z004J9nOG@:O00MMWehY=In200:O00B2Wihi
0Yl01X:OWh:O=09Y00=iJIl00SD2W`0@GYn2GYn2WYl9=Il9GYn26@:O00U/:InO:IlePYl00Yh019n2
Wil4j007=InV:CFOYP02W`05:IlePYl00Yh01in2j>PiWh800`T00oSX2@042@05j0Whn1T00PT01>Sh
n?P4b003K:SX00;800?hb>P02/P00jS8Z001b00000=YFET01:D01NVUY:BU00>T00n6Qk60ERf0nUH[
HXL]H[X01hL04beE00:N://K^R[jbkYKbhWYm@001@`00oD<300330Ke00?;mOD00oD03`0<m@2;mNPY
JBYjn0aX0002m@04N[P030;;0X/9:@06n3TYn2Ti0RT01CTY:BTi008Y13T022Ti:ATY6BTI1BT00`Wh
n00:n00>2OPY^?SXn1TYJBUY6OP2j0:h00CX^>Pe0il01SD9WimNG@:O00=NGIl00il010VNWih2Z004
^5fO2@:X00ZhZ5fO2IP9WiiM0Yl01kROW`VO=Ed00Yl01fVOWcVODST00Yl00cVOW`03J@0:PYldWYle
PYnNI0BO00Bh=In20Yl01cDYWile>CD00il00cF2W`06W`CX00>2WcD00X801IleWijV00NO00J2j<Sh
Wih22@07n>Shn>P96@032@05n1T92AT00oP8b0;X00?Hn<P01<P02:S8Z<RXb:S80ZP0000<>JFUYEVU
jJFTjJB60j@02HJaH//0EUD[E@020004bnYEHPN700H]:`08G[l2000;Fk[:6gZj07Z9R`001``01OD<
m@ce008<0oD00`cem@04m@0F3?D<3?F;2gZ9NZS;ZGXZ2iYX0?G;m@8Z0RT01STY:BTI>@8Y00?h:BT0
0RT00cWh:@04:@8i00<Y>BT00RT00oPY:@07:@03n0Wh008I00Kh6OP9n1T2n006>OShn2Wh0^P00`TI
:@02J@03:@Wh00:h1NP01SFOPYmM2@:O00nN2InOGUdeGSFNZ5fOGKP00jP00imNZ004Z00XWejXGCEM
^3FN^5hePSF2>CFNJIhePSF2:CFN>C@eNEUi=3F2I3EN2@8e00T9PYleGOPeW`T00il04QTeWSF2>CEB
=Ihi=H8eWh:OWPGX00NNWh;XWYle008Y00heWYjOPSFOj<SXn8:O>@8900?Xn>P00`T011WX2NP22@03
j?Sh00;h1LP01:S8b<P4n0G800RXb:S8Z<RXb06X0002Y@03FJFU00:U00>TYJ@00j@03^VTQRgeENX0
mKZ6;EJj0_D00f:7Q`05Q`06;L/0<jN;0P002oF;3<^j:/^jJH/000D<00Ce30`<1OD00`cem@07m@03
boG;00;e1P002L]KbMUKm[Qj0002m@03^XTY00@Y00@i:BTI0RT00cTY:@02:@04>BTYn0HY00?h:BT0
0RT02?PY>ATYn2Wh0bT4n0032ATI008I00<i2AT00PT00oSXn002n08Y0fT01ST9:NRhj0>h00<eWnP0
0^P00kPeW`02^003=Inh00:h00>X^:P00ZP01;RXZ;P2Z00?GYnX^:RhZ5jO^:RhZ;SX00>h00Chj?P9
0ST012TiJCT3:@036BTY008i00AINHUI0VT013TY>CT22@03>FTI008900WH^3FO:EjOPQT032T01OPY
n>PY00KX00@Yj2WX0bT01JHY:BWh00?X00[hj<SXn9n22NP91>P32@;h00CX2@T90_P00lRhb007b0;h
00?Hn<P00/P00jS8b004b003Z<RX006X0004Y@04jJFTY@>T00BUY:BT0XL01P20;NYF/@8]00?ZHXH0
0[48Q`0=mP02ooEKmR[oJB]K^P02>`03NX/000L<00Ke30`<m@`@m@;;0oD00`cem@02mP050</;2``0
0//01@cJ:BTi00<Y00@I:ATi0bT00cTYn009:@09n2TYn1TYn2Wh00<Y00Kh2@TY6OP46@0;n2TI2AWh
2OP9n1T00_P00aTYJ@03J@06:OShn0Vh0bT00cFOj003^006GEkX^5fN0kP01nRX^;SXZ;P00jP01;P9
Wed3Z004^0VOG@Jh0_P01^Sh6CTY>@9Y00<i:BT01RT2J@9I00AYFFUY0ST010Ti6ET36@?H00PeWoRN
Wh89n0LY00Oh:BWh:OPY00;h00?Xn>P01NP2n005j2TYYST00RT00oSXj003j0?h00BNWnP90^P42@;X
0oP22@04n<Shj0;800?Xb<P00lP01=Shn?P3b003Z<RX00BX00C8Z<RX0LP000>U00CYYJBU0Z@03^VT
Y:CYY8NaQbfa;EH[0UH00fZ6Q`09Q`0<HSVXPUd0NYQ^6gWI0P001``io``03?D00P`01?D<3?D23003
m@ce01;e0//2m@08boD<3<_e00`4b`03:RTY008Y00<i:BT00RT01QTY>CTY>@TY00?h:OP010T011Wh
6BT2n08I00?h2OP00_P01RTIn2Wh6@890_P00`Whn002n08900DYJFUY:@026@04n0Wh:@?h00LeWoSX
n;SX00Zh00?X^:P00[P01JRh^:Rh008e0[P00nRhj002=@:h00gXn;Sh^?P96@Ti:FTY008i0RT00f`Y
:@03:@04>FUIR@9I0fT012Ti2@T36@8900KH^3FO^5h2W`03j2TY00<Y00?h:BT00RT00oPY:@03n003
j?SX00?X00DYn>PYn003:@07>BVV:AWX2@02j00:n>SXn8:OPPWX2@CX00?hb?P01OP01MSXb:SX00BX
0lP3n005^<S8j:P01NP3Z0780FP000>U00FTYJBTY@03Y00;YJBUQXL]HX1En//00eH01RfaH/^6;@J7
01606FSXWc@0:PUXRF?;00aNG@0400<<1oD00`cem@0=m@03boG;00;e00?;mOD02L/2m@04nBUY>@<Y
0QT00bTi:@0<:@04n>SXn0<900CH2AWh0`T00oP9n002n0<I0PT2n08900@in0T90oP22@8Y1FT00`Wh
n002:@0;2BT9WSGhj;Sh^?P00[P01oRh^2WX^>P00[P01=SX^=P4^003GCD900Bh00>2=BT00^P4n005
2OP96BT00ST2J@05>BTY6F`012T01CUYFEVU009I01=Y>FT9J@UY2AT9n=ShGSGh:CFO00;X0RT02?PY
n2Wh:OPY1?P00bWhj006j004:OSXn08Y00>VYBT00RT2n003j?SX00;h0^P00cF2j002j003n>Sh00?X
00C8j?SH0_P00lSXj002^0:X00CXZ>SX1OP02nRXZ<RHj9SXV:SX00>X0002Y004YJBTY@:T00>UY:D0
0j@03^T]EP0<boD[EUF0;HL]0VX00k67Q`04Q`0F:ZJXj5iMm@bj<R[XH`2oGEN0bY_e30H00P`Dm@03
boGe00C;00?eboD01</2mP09bBTY>BTi6FTi008Y00AY:CTY0cT5:@03n>Sh00;H0_P22@06n=P9f0WH
1OP010Whn1T42@03n0Wh00Kh00@96BTY0fT2:@032OP900@Y0_P00bWhn002j006^2Wh^2Wh0[P02nRh
n;Sh^=Rhn;Sh00:h00Ch^?Sh0nP00kShj006n08I0bT2>@03JJHY00LY00HiJEVUFJD2F@08JCUY6FWh
JAT3n00;f?Sh^?P9n>PYj?P00bT03OPYn2Wh:OPYn>Shj?P01nP01_PY:JHYYP8Y0QT00oSXn003j003
b>SX00KX00C8j<SX0lP01>S8j<P4Z003V;RH00>X00?Xn?P00_P01LSXj9SX00:H00CXV>RH0ZP1J000
00FTYJBTY@02Y003YJBU00BU00V6;F:0Q[66E[X00hL01K67EV:a00F701aRQ^QXZ889P_JUolW:N/^N
j?SoZ:FTP6XKVl/<1@000`cem@0:m@05boG;mL/00_D01L_emL_e00K;00P0f[YY:CTY>@8Y00Li:BUY
:CTY008i1BT00oPYn005n007f?Shf0Vh2@04n003j?PI00;h00Di2AT96@022@Kh00D9n0T9:@04J@03
>@TY00HY00?h2OP02?P01kSh:ORhn>P00_P01=Sh^?P2^0;h00Vhn?Rhn;SXn>P01?P22@03n>PY008Y
0VT00bUY>@08:@04>FUYF@=Y00BUFETi0QT016TI:AT2n004^=Shf0?h0^P2:@04n2Wh:@;h00<Yn?P0
1OP5j0?h00DYn2TYYP03>@05YRWhn1T00^P00oSXj008j003f<S800O800Nhj:RhV;RH00>h00?Xf>P0
0oP2j005Z>RHV0T00iP4Z00000FUY:BUY003Y@07jJFUYNVUQP03;@:700ARQ_Z60[400h1KEP07Q`0D
HXJXJ6cHPZLd3?G;30QM2H8Ib>P2K003J?m/00:U00F0_ED;V`0200043000008<3OD00l_eb`08b`05
3>TZ6CT01bT016Ti:FT4:@07>BTYn2Whj003n006f>Shn=SX0oP00mSXn003n008:OShn1Wh2MP3n003
j?Sh00Ch00<9n2T00fT013TY>OP2:@052BT9n0T01?P020Whn?SXn2Vh1?P00mShf003n003^?Sh00;h
00GHn?Shj007n0042OShj0<Y00@iJCUY0RT01?PY:F`5:@06JEUIYEVU15T01AUY6FTI00;h00<Mn;P0
0[P01]P9f>PYj08Y0_P00bWh:@03n003:OSX00OX1?P00bTIYP02>@:V0RT01?PIj?P2j007n>S8b>S8
j00=b0:X00NhV;RH^9Rh00;X00Kh2OSHn>P3^003V1fH00:H00<9V>P00ZP00004YJBUY0ZU00>6/B/0
0f/02@a[Q_G;Jh_Z/@07Q`08H^WHf:QX>Eh2Y`07GSB22JN2Z002j0096CTi:LRUY7`I009/00=XZ:D0
0X001:XKRoD600043<_;m@o;00?ef[X01bT016Ti:FT2:@04>FTiYP@Y00Gh:OShf002n005f?Shj=P0
0oP00nSHn003j0[h00?Xn?P01_P00aTi>@03J@04:CTY2@8Y00<9n0T02_P00nShj002n008f0WH2OSH
n=P2n003f?Sh00Gh00<9n?P01_P01`WX:JHYJCT00fT5:@036BTY008Y00LiJJEYYEVU00AI00>7FBT0
0RT01OP]^2gh00:h0_P3j005:OPY:NP00_P00nShj004n003j?SX00;X00D9j?PIn003:@:V00LYYZHI
n>Sh00;X00?hj<P00^P00lSXb00=b005^:RX^9P01KP01?SXn0T3n0;X0kP00iPMV003V06X0FP000:T
3:D03hJaJl][EH27/BeFP6:7EP07Q`0DH^U/Z=RXooPdG@TeGH8ioaVTK>P2Y`072EfWPZHIYP03Y@09
O:A/f7bUZITd008b00>;m//01@000`ceb`0;b`033?XY00LY00@i:BUY0ST3:@04>BTY:@;h0PT03?SH
n?SXf?SXf>SHn0;X00CHn?Rh1_P00nShn00:n08I16T00bWh:@04:@03j?PI00;h10T6n003f0T900?H
00@9n?SH0_P00mSh2@05n0036OSh00Gh00?X:BT00RT013UY>FT2:@07j2TI:F`Yj002:@03>EUI00=Y
00>9FJD00eT2J@05:OP]n2d00_P00kShf002n005j2WX:OP00RT01OSXn>Sh00[X00<In?P00_P00bVV
YP02>@<Y00PIn>SXn>Shj0S800>hZ:P00ZP5b007j;Rh^1fh7@04^003f?Sh00;h0^P2^0042Afh7@>H
0jP000jU0127/K5RjR_ZQ_Y[mV_Z35H]1XL04h29ojSHj9SHYJUY>NV9J<RUYPT00]P2Y@07Y:Di2JLi
J@04PP8i00nTjIVaGQUTVCA^E@/bFi/00_D400033?Ge00;;00gfbl_;NVTYJBTiJCUY008i00XY>CTY
>FTY>BTi0bT01oPIn?P9n=P00_P02]Shn=Shf;Sh^>P2n00:^?SXj?SHj?Rhj0?h00=YNWT00_P01ATi
JCUj008Z00[h:BWh:KPI^8TZ0nT01oWYjNTZRKP00PT00kSH2@02n009^0WHn2[:^][i00Gh00<Yn1T0
1?P00cTZn@02n@DZ00=jj2T00RT026`I:BU@NZEI0ZD018VUYJD5F@08JW[Y:Bgh7MP2n003:BXZ00;X
00PYn2WhPBYj:@;X00Ghj>SXn003j0052NSX:GX00kX01L[YYZHi008I0nP01oSXj<QY:X401<P00kRX
Z002Z003JBZY00;800KHZ>Rh:Ad6^006j?Shn0WH0nP010VH2IP22@04^9RHj05X0006Y@03FJEY00BU
0XL02HK;bf_em^X[R`02P004^UER/@J700N0FOo8Z6c8009Y0ST2n00DFFW8V1VUZ=RUY3TIYJ@IJJBU
:JH2J@03>H:I00:I00Z2FFVUDRfIEe9N0RX01C=j>e_;00<<0oD01<_eboT3:@09>BTiJCTYYSUY00<i
00HYJBVV:CT2:@036@T900;h0PT00mSh2@08n003f>Sh00?h00SH^>Sh^?SH^0;h00<K03/00_P011Ti
JOH20003bBWh00@Y00>h:C/02@0013_hf=P22@06n=Sh2KS91`0016Whn1T6n003j84000T022T20004
beVUJ@>U00IIYEUIQbX20005b_P]^?P00[P01=Si0002:@04n2TYY@8000T<n?SX:NShj0T01NP00oH0
00060003fRTI00;X00Ohj>SXb>Pk00800/P02:S8Z:RHZ9Pk0P03b0;h1;P00iPMV002^004Z>S8n0;8
00SXZ9Rh2IP97@:H00<9Z:P00JP000RU00/iJEUIYHV7QR]FP002QP:700L]Qbf7EH0]00J700URK6RX
j1TiFFT00RT02CTYFHTiJ=RUn003Y@032MSH00:T01]MRJ@YJJFTYAUZPYiGVHV2:YYAVFhd/EjW;RT0
0X801NVJ6h_;008000>;m/T00RT00cTYJ@03>@06JCTi>BUY1ST3:@<I00<9n0T010T6n003^?Sh00?h
00OX^?Shj;Sh00;X0_P01>SJ0?X2j0036CTZ008000G:n0T9n002j004^0Wh2`T000@;f0Wh0mP010WH
^8T30003Rm[e00<000Din1Wh2@026@04n0WXP@X00bT2K0<Y00<Z00001:D01HVUYEVU009I00O;003h
:OP]00Ch00CY003X0bT01_P0003h:@Ch0nP01?SXj2X40004bkYK30<000g;n>Shj<SXb>S8nP3e00?8
1JP01iSJ0?GXb>P00_P00kPY^0027@>H00BX^:SH0nP2Z007j9RH7IPM2@03^07X0JP000:U00AIYEVU
13T01FUIYHL]00F700=FH[400k4012gZH[45Q`04QX3hb0?H00EY:CTY>@04J@03N@UX00>U00GHYJGH
Y@02Y0032JNT00:U0Z@00k6UD@02Y@04DFjI@0:200LeKYTdfEiS00;Y00QSGSUN/H9NK0=j0VT00bUY
>@09>@03:FTi00Hi00<I:AT00aT00oP92@022@8I0_P00nShn004n00:j?Shn>SHn;SH^0?X00Nj0=[H
n0TY008000@<>OSh0nP03;Shn;SJ0?Khf?P9^0Ch00GHn0Whf002^006n0000?SH0PT01BT0000900<I
00HY6@T9j:D20003YSTi009Y0ST2:@036BTY00DY0P000h^9R@02Y@06RJGYFJEY0P000a/Yn002n0:h
0]P01LT00>PY00;h00@k001/0_P00bWh:@03n0?X00DZ0000:P04j08Y00@k0?DI1>P01lSXb6cj0?D0
0/P3Z009V6RHV=X0bjSH00;h00@9^;PM1YP01:S8b=P2b0;X0YP00jNH7@02V0032KRh00:X0005Y@@i
00TY>FUYQk4[P6800_X026]FQh1EnUFj1hL00f;Yj002f009b1UYJCTIJETY00=Y00MI^=RUf:PY00JU
00<iVJ@00jD07cV2P7=SKU9T;WTdKWb7@6jIRIiT;NV7I6<ZWZElmKX00ST00fTiJ@05>@08:CTi>FTi
JCT2J@8i0RT36@;h0RT00oPY2@022@036OP900?h00@9n?PY0_P012Vhj>P3n009f;SH^P3jj?P900<0
00<Y>OP00^P03LSX^?Rhj?X0mNRhn;P00_P02mShf?SHn=Sh2OQj00801PT01hT00>TI2CT00PT26@05
:H400:H00ST01fTiJJI/:F`00RT01^PYK2U/bP801ZD016VUFA/2000:JAT9n;SHn=Shb@800bT01>T0
0;X3:@09n2Wh:OSXn>R1008000?eb>P01>P01ATY:G[f00?X00?8j>P00lP00oX0m@02b0:X00RHJ9RH
J=X0b`Ch0kP6V0>X00CXb<Rh0ZP3V0@M00BH2KSX0LP000BU00=IYCT01CT01UV6/O[;mP;e0UD010ce
Rb/2nP03;HN700B700URQ]SHZ<PYFBT00ST02VTYJFTi^:G9J6`2f00?K:E/f;RUO:FIY3VUJITi00:U
01b7NH9IQeiiKT2UP^UEY9VPQd15bK5nDX:U>`^V1cT00bTiJ@03>@04YSUYJ@<Y00<I:AT00QT00oPY
:@04:@8900<In?P00oP011Whn3T5n005j?SXn>P00oP01]X0f]Sh^P8000LZJ@TIj=Rh00?X00Fhf=X0
b`02f008n=SXn>Sh^=P2n005f?Rhf2X00P022@09n1TY:@We03/Y008i00<Y>AT00RT01X4002VV>@9Y
00<Y>F`00RT00aTYK003:@9Y0P000lZUY@06Y@8000B;>ATI0PT2f003n=SI00800_P01BT000ch008Y
00Ch:OPY0oP2j0<000?hj<P00^P00oSXn003:@05YQWXn6`01<P016bj0?D4Z009J9RHJ9SJ0<^h00;h
00?X^;P01iP00fRX^002b004j<RXZ0>H00<MV1d00iP1j06h0NP000>U0eT5>@06JCV6;L][0UH02[Z0
P8L]Qk66EBd6Q`05H^W8f:P00RT03VTY:FTYJHWXooQY:Fb90nT2KP06HaXJjCVW0jD00gWYY@02Y@06
:Ej9RH9N0Vh02ENPX6bmEMW9Y@02j@08I8N0=Ej2a6T2K004YRTi:@Hi00BV>CTi0RT00fTYJ@02:@8I
0bT01CTY:CTY008900PY6OPIn1Wh2@?h00<in?P01OP02MShn?S:0?[h:@020004mVTY:@?h00kXf>SH
n>Sj0?Ghb>Sh^0;H0oP00mShn002n0890_P00`Wh:@03:@04>L/06`8Y0ST01BTiYRV1008000<iJFT0
0VT01SVVK6`YK0<Y0V`00fVUmP0<000;FFTin0WHn=Shf<T00P000oPYb`020003K2TY00<Y00?h:OP0
0_P01^RJ001/n0KX00Sh:JHi:OSXn0;X00O8K<S8nP3e00BX00^HJ9RHJ=X0boSXb002^003Z9RH00FH
00MXZ<SXf<SX00:X0iP011fHV1d2V06X0NP1j00000BUFJFU0UT2>@07:CTi>EV6;@02Q`:000<]/H00
1;400oZj/@06Q`08P8Wob=PYJBT2>@046HUIZ0;o00DYJNUn<P04<@0:<S4a<C9^I:ElK0BU00iIJJ21
RH:7KUN9PZJU_@9b00jmL[fTVD1nEiiNa6bVY@<i00D9>CTY>@02:@05>JHY>FT00bT00aT96@036@<Y
00@i:BT90QT00oPIn0046@04>ATi6@<900?h2OP00oP01`Whn;X0^_P00`03J@0@:@Whn;Sh^<SXf=X0
blSXf0Ch00WHn=Shf?SH2NP00_P5:@03>BTY008000<k>FT016T2YP04P@00J@8i00EY>FVV:@02K003
:Fa/009/00AYYJFU2`001L]IFCTY00;h00GHn=P9b@020005n?T002X00bT01?PYn2T2n006j?Shm@3;
0^P00lSXn002n003j?Q/00@Y0^P00lSXb003b003bP3e00>X00BHJ9QX0YP02=X0bkSHj;RX2IP2Z0;8
00_hb>RXV:LMV1fH7@03V0:X0003Y@9I00AY>FTI0ST03VVUQbf6boG;<HN;0?YR0XL00bf7Q`05Q`0A
P3WoZ3UY>BWhZ:T9J?nXf>T01384E@072eEE6c][<@02KP0APRU/jLVhGD1TQfAijCATYF`01kd02g:m
jF8d=H8i:FbV00@Y00<i2CT00RT013TY:CT2:@0;2BT92CT96CTY>OP01BT00`Ti6@056@06:ATI:CT9
1OP010TI6OP22@04fP1j:P8000HYJFUY:AT2n00:f>Shf>ShfP3ef0;h00CHb?SH0oP00nShn002j0;h
00TYn2Ti:CTYY_D00P000jEiJ@03N@<i00>Y00001FT01JJU:F`Y009/00@YK2UY0jD01``0bnTZP6X0
0X020005:ZEI>BT00_P2f003n=S9008000@i002j1BT00oPYn004n004:@00j@;h00?XK>P00^P2n008
:JJVYRWhb>P4b004Z?X0m@:X0VP029QXV9QXfP3;0lP2Z0RH00MXZ<SHj<Rh00:X0iP00afH7@02V003
YiRX007X0002Y@AI00AY6CUY0ST03hNaQ_KZQeK;EV;j3<][HP08Q`04P1Won09Y0RT00fVXZ002o`07
n;Xb<C;Z<P02E@062eD;ENYE0Q/03@/K:c4bFFb0b^V6Hfh00^T01Kdb=5VU00:m0Z@01:FTY:@2_@09
O81^=A_jYBVV00<Y00@9n1TI0PT2:@04n2TY:@8I00?h>OP00aT2>@DY0QT01OPI2AWh00@Y00Ti6AT9
6OP9n1T00`T01?PI2MX50004^XUYJ@8Y1?P03]Shf?SJ0?Khb=S8j=S80oP01>Shj>P2n0@Y0f`01JX0
000k009Y0hT01FUiJJKY008000@iJCUY0ST01JHY:F`Y00=/00IYYJF9YH020003jJFU00:U00K:002U
JET2:@07n>SXf?P9b@050003FoWh00Sh00?Xn6T00P001OS8j?SX00Ch00@YYRVV0RT01^Shb<RXb0:X
00G:0<]XZ004J006V6RHNP3;0/P3Z003J9RH00FH0ZP00nS8n002b0:X0YP00afH7@05V0:X0003Y@03
FFUI009Y0cT04VVU/H1[EX3ZmH1X/H3jJnZ7;@F700^6HPWo6FTY6@UY6@02o`0=YP_f<^Xb^^ZjE@_j
E@022`04EA][J`8K00H;:a/YY<T2Y@09;EjNjBY^PS=d00:U0[d2Y005YKfmY;d00X001YiK>jE/:@;h
1@T00aWh2@02:@066OP96OP90_P01PTI6OPY>@8Y00L96@Ti6@TI00HY00LI2@Wh6CWh008I00@9n2T9
0QT00mX000050003nVTY008I00Sh2OSh2MShnP8000>;m_H00oH01P2Uf?P9j0;h1BT2K003^P000080
00<KJJD00ZD2Z@05YHUYJNT00P02mP;;00CfboDk0RT01V`YK6VUJ@BU0P001C^UYJGY008000UEJJFU
>BWXn>P00oP00mT000060007n>Shn>Shj003n007Y@00n6cXn003j0?h00E/YZHYn002j0?80jP00mX0
000;0004bjS8J0:X29P016RXZ<P2j003b:SX00BH00<MV1d00YP3Z0001:D2J@03FFUY009Y00JUQbeE
0?H2:`08EH26j_Z6Qbd7Q`07QX3hZ6Ti:@026@07JCW8j5I[<P02^P9E00?ZEOX01@/00oY[F`026`0A
>a][Vc:U>EVU6FB2I:ERWX800jD01;fT_JD2Y009_JBTP;f238/i00<Y00<9n0T010T2n0D90aT01oPi
2ATY6CT00bT011T9>OP26@<Y00Sh:BTI>OP9>@;h010I2@TYn2TI2AWJ03^9bMX<0P001gYY2AT9n=P0
0`T00mSj00080007NPWH2NPYn004:@03K7X000<000?ePJD00ZD3P@:Y00BURGWY2P02:@04K:DiJ@JU
00>j00000jD00lX00002Y@03JJEY00<Y0oP02>SI0039JOTk0`001>S8j>P4n004j:H000;h00CXK>Q/
0oP3:@04YRWhj0?80jP00fSJ000<0004bjRXb0=X1iP2Z0;800CHn:SX0YP011fHV1d4V0:X0FP000FU
0UT026UIJFVUQRf00XL2QP05/EH[Qbd00[400hJ7Q`05Q`06H^WH2BTI0RT05MPI:OPZ:c9nENYEjUFj
jQ_j2oYE2`02J`04Fa/K6`>K00<bn6`00ZD01fUSFF<K=9T02JD02kfTYJB0_EM^YATY00@900?h2MP0
0`T01?PY:BT66@042ATI6@DY00Hi2OPI>AT5:@8I00Tin0TIn1T9:OP00RT01`TI:MX0b_P00ST01fV;
001Y:AT010T01oPI2OX032X01GX00kYYn0022@;h0RT016`YK;X300036jFU00:U0X402JF1PH7IZHUY
j@0200>j00RJ^WZj:ZI/YP9Y00=IYJD01JD20006^ZFU302K0jD2J@8Y1?P01>SI0004b004Z@00b@?8
0^P3n004:@00j@;h0^P4n08Y0ZH2:@04j<S8b0:X0VP01=X0mBT4J@09FFUY>C/0bjS8009X00>XV9P0
1YP02FRX^<Shb;SXZ003V0037IPM00>H0jP000>U0UT01JEIYJDi00:U00n6/K7jJb][jUJ7QUIR^^X0
1hL04F:7n1UYn6T9b6RX:S7ZOUKZ00EE00<;6a/00Q/07oXKJe][Vf/KJi][Rfh9K3WYGX9^:`^jnQ^m
YG[Y_JD01J@2P005WYTY:AT00PT00cWhn0032@03n0TY00<Y00=Y:FT00bT2J@056FUY:FT00bT01ST9
>ATY6@<Y00<In?P00PT01oPI6AT9n2T00PT36@03fP0;008i0VT01HT006TY00@I00Oh6OPInP3f0089
00?h:OP00_P46@DY00<iP@000P02J@JU0X400nVYP@02Z@04ROT000AY00@iYJJV0f`2J@BU00GYYJFU
jP02000:YBX00:EIjFVUJ@8Y00KXn>Shb<T20008Z>S8Z<Pk0?H6b0;X00M/R`00n6cX00Kh0jH00bWh
b002b0>X00EXZ<X0b`07J005V6Rj0</016P00jQXV006V0:X0/P01?SXb:P3V007YiPMV1fWV002Z05X
0005Y@03FJEI00BU0127/F_fjUGjP5D0mB_f0;Za1XL00f9I2@04:@0BZ6WXf?XbOS9F2eD;ENYEnQ_j
11/05i][6a]KJb^KJi_;VMP9VNUN<eFj>h]K00:m00eKRe/kRoZjM:ARP:J2008Y00@in1Wh0QT22@04
n2T9>A=Y00@Y>ATI0PT2n0092OPIn0Ti:OPI00D900PIn3TYfP0;2@8i00EYR@00NP02:@8I00[h6ATI
n?X0m@TY0oP00bWhn0026@03n2TY00@Y00DK000iJ@06Y@05PNV1PNT00X400jV9:P020005RFUYYVT0
0ZH2K003YVaY00:U00QYYNUYjJEYY@8000OY6`00YNUY00:U00IIJBTYj<P2j00;V@00Z9RX^9PZ05/0
0kP5b006n2X0087h1NP2n08Y00BV:NSX0/P00jQXZ002J003fP3e00IX00RHJ:SJ0<]Xb0=X29P2Z007
j<S8j;RXj002V0037IPM00BH0jP00003/JFU00BU00F9YJFUP@02Q`07368]QV:7P002/@04EKYZ;@N7
00b0R@TY6BTIZ3W8jC42EP03jS9E00EE00P;6a/;6`^;J`>K028;Jf][Vf/0N[PM/HM0=9UIPKf0YKfZ
_@]KmU^ZY:GYEI[Y0ST021Tin3Wh6@Wh0RT00cUYF@05R@03JHV900>900EYRFV9N@03J@046CTI6@D9
1?P26@06n0T9n1Wh0QT01RWhbP0;PP8i0VT20004nBTYn0<I00Kh6AWj0?D2n005:OShn2T00oP3:@8i
00NVK3/0bcUY00BU0nT00h7Yj@02j@04ZMVYn@8000>9JFT00ST2K006YVbUJJEY1:D00nUYY@02Y@08
b`00m@3YYNT3Y@09JCTYn>Shb>R900800ZP02IRhV=X0biRhV002^0G80`002?S8j<SXn>Sh0RT00oPi
j002b0>X00IXZ6Rj0?D7J005V6SJ0</00fP00jQXJ007V0>X00?Xf?P00^P3V0037IPM008M0YP1Z05X
0FP000FU00=YYET00VT03ZF7QhL<mOKeJeD]EX0]0[48Q`03HZWX008Y00HI:OQX6I/4<P04EUD;E@8;
00=E2c/00V/26`03Ji][00:K00P[EF/[Vf/[V`8M00HIPX8YPVT2Y@9/00>UK:D00ZD00gBm_@02Y@04
Y3]Kb@8i00LY>@Wh6CTI008Y00DiJEV9Z@0@R@=Y1`T6n0046OP9n0<900Sh>@Wh2`3j:@8i00EYnP00
>@03:@03n1TI008I00ChnP3;0RT01OPY:BWh00<Y00Pi:CTYK2TinP8000=YYJD00ZD00h3ej@02j@03
PNV100;Y0ZT01BX006Ui009Y00JUYRTYJCT:Y@9I00>U00000P02Y@08FJEYYEUY:OP2b0:X00>90000
1IP200066kRh7KRH0[P3b006j0000?Q/1NP01OPY6`cX00?800>XJ:P00VP00mX0b`06J006V6RXfP3;
16P00jRHV005V005^:Rhf>P00_P01[SX^9PMV08M00JH7IRHZ>P1Z00000MIjHNUQh6U00C900GYQbeZ
jP02EP03EHJj008000?jQXL028L05829n2T96CTIb:ZKOUFjEK[Z2eD;0eD36`07>a^KVf^KE@02:`0@
2i/KEG<0FIPIEiW95FBTY@A/00BUK6bT1JD00oGfj@02>@07JCTi2CTI:@03>@03JJF900:900>YJHT0
0XT00jV9R@02R@03NFV900:900UiJBTY6OP9f?P010T2n0D90_P020Whn2TifP0;0ST01ZV;003fJ@@Y
00?h6AT00QT010/0mOP5:@8i00Kh>BTY>BT2>@05YZD00?D00jD01>T00005j@05fH7IfBX00P001=Ui
NFT2>@:U00E/JJEYj@07Y@03>FTi00<000ajYJFUjJF9FCTYf<P2Z008J9T001fH7FX30003;Ad]00Bh
00>H^;P00/P03X40003jb?Q/b>RU303;0lP2Z09X00FXJ<X0m@07J008Z6SJ0<]Xb6P2Z0BH00HMV;Rh
j;P5n004^>Rh^08M00JH7KRHj;P2Z00000>URJD00ZD3j@05bNW9P8L01;402HMEH[4]H//0jP08Q`0I
HVWh6CTIn:SY09]nEC;Z<UD;E@]E2oY[>`036`04Ji^KV`9E00<[Jb/00W<03eD<N_m^mEUENX^URkZ0
NP04j@03_JFU00>U00UE2jTi:@Ti6CT00RT3>@9I00>9bJT00XT2J@>900>URHT016T3R@9Y0PT01_P9
n?SH2@;h0PT3n00:2OP92OPIn1TY2`P00fT4:@@I00<K00001`0025/Y>CTY>F`Y0f`01E/0003;00@0
00>0jNT00^T01X7YjH6YNPX000=YYJD01:D01>V9YJD2J@03>BWY00800jD00nV9Y@02Y@04>OS8b0>X
00>900001P0019TM;Ad2;@067KRh^9Rh0/P00nP000030003m//000<000@kj<S80ZP01fRXJ6Sj00`0
1VP01YQXZ?X0309X0jP00iRh7@06^0;h0PT01oSXn;P97BT00Qd00`WX7@02^07X0JP00003QhWY00OY
00CIQRf00oX2J`09EX20JUIZ:hH]00F700ARjATY0fT01JPYJi^j008b00^j<[ZjnP_j2eD;F`02J`03
6h^K00:K0UD00b][E@02_@0FLeE[>eWj<PPK2<^m08_jbeDkbe/kY0Bm00=/YCT01CT2:@<i0VT2Y@03
RJV900=Y00=iRHT00XT00gUY>@03J@07NHUYJBTI2@02n08900Chf0T91OP00mSh2@022@04n1T9fPD0
00?e^XT00VT3:@03>BTI008I00?h6`0020001?Xi:CT3:@=/0VT00lX000040003jJCY00KY00?IZGX0
2P000eVUY@04Y@06jJFUYFU/0bT0102;YFT4Y@0:RJDYn=QXZ6RHV@D000<<mQd00Rd011d]7Ad2;@05
7KRh^:P00lP00kX0000500043?T9j0;80ZP4J003fP3e00MX00VHJ?X0bfS8J:P01;P01Afh7BWX00?h
0PT3n00::OPY7BWh6Afh:@;X0LP00003bNWY00CY0]T2KP0;Q[7f0?D[mOYFjXH00XL00bf7Q`06Q`0:
HXIXonPI>JRZV`9n1UD32`0>nP/;6f/KJb^KmF^m:a/3_@9c00UE:l^jP6WeFgT00ZD02U1dP:ZU6e0k
D:D2Y006P:A/K3UI0ST2:@=Y00LiFFUIYHV100:90fT01WUYVJF9N@9Y00DYJFUYR@02J@@Y00@I2@TI
1@T00mP92@022@03f?Sh00<900LYJBTYJBUY009i0VT2>@0;:OPYn1Wh6CUIK3T016T01CUY>BTi008Y
16`3J@:U0kX00h3Yb@06j@08PNWIfJWYfJT2V@05RFUYJH400ZD00hWYY@02Y@05RJFU>F`00RT2K003
ZVZU00BU00F7YETYf003Z0:H00Rh;BdM;BT]7@P]00<M;Ad00kP3b00:j<PinBYj:VVV:@;X0/P00jQX
J004J003n6QX00IX0jP01?RXJ6P4Z005V;Rh:KP00_P00nShn003n0?X00Rh6NPI7@TM:@:h0NP1Z000
1>T00mU^f@04KP0?QRf6;K67JUF0EBfa;OZ600N700j0RJRXJ>RXYI/bOUIEjP9E00?jEED00Q/22`03
6i][00:K0P`00b^mL`05_@9c0R/00f_Jj@02:P05bYU/K:D016`01:E/YJD4K0;Y00UY>CTYJBUY>JH0
1FT00jF9P@02R@9Y00<iJFT00XT01FUiJFTY009Y0hT3J@8Y00HI:AWh:AT52@Gh0PT01NPY2BWX008Y
0VT01GV9JFTi00DY00@I:ATY0QT3:@03K2TY00@Y00=/:F`00V`00bUYJ@08Y@[Y00F1fIVYV@03N@AY
2JD2J@9/12T00fVUY@04Y@9I00Ohf:QXZ9Rh008M3bd00ad]^003^0C80^P016c8n?P2:@046LS8b0:X
2FP01omXJ6RHJ:P00fP00lQXJ002Z005V;Rh^1d00[P3j003b?S800;X0[P22@037ATY00>h0nP1Z000
0^T016kIKQX5KP03Q[4]00:000^aEV:jQh0[QUKj;@06Q`0:HVVXj:SHJ80bEP8b00=EfUD00UD2jP8;
0Y/02V^KV`a[_H2UY:D9_@0;:k[YjGXdGJFIEjD016`00jFmj@02K00;YFbZ:oTi:CTYJJH00ST01:Di
JCT2J@B900ai>FUYNJFIRGUY>BT2J@B92VT2:@046@T92@Ch00cXn?Shj?PYn2TiJET3J@8Y00Kh6OPI
n0T3n003>ATI008I0cT02QTi6ATY6BU/:FT:Y@OY0h42Z@06VHVINFUi0fT018VUYNT5Y@8Y00<I:AT0
0bT00cVUY@05Y@05>MS8Z6P00iP37@<]0Qd6;@037BdM008]0Qd019Rhb<P3K00;b?Shn2TIn>Shb:P0
4FP00jQXJ005J0>H0kP010Vh^>P3b003Z<SX00;X00DM^1d97@022@03^9SX00:X00026PQ^014JQbd[
06^6nR^0/HNj/BeE/@06Q`03P6Wo00;H00=/Z3800S801EHbENYE00;j00l;6`00Va^ZN^U/:MQ/Z=P0
0ZD2Y003_JBT00:m00Yc:e_jjKZ;6eNJ0[X01LXZ:]XZ009d00SYYFbU^Q_9>@@Y13T01jDi>GUIRH40
0XT00gUY>@04J@03VGUY00AY00>9bJT01HT8J@03:AT900<900_Xn;YjVWZZNZZJNP03^P05b[ZjZ[X0
1:X00kZZ^P02^P06Z[ZjD;ZZ0[X02JZjZ[ZZD:ZjD002^P06EKYEEK[:0[X00oZj2`032`<K0_X3fP03
b[Zj00Bj00?:^[X00lX3^P03Z[ZZ00JZ00M@^[YEbP_:00:j0WX012Yj:VX2NP09OWXbNWhbOS9j009n
00PbOWhbOS9jOPQj00IdNZYjVZX2VPEj00@ZNRYj0RX00gXZ:P05:P0;NRYj:WXZNRYj:FP00YP4^0>X
00G8J<QXj003V0037@VH008M00>h2IP00jP000Y^00PJ/F[;P?KenP9E0_H01@1[6f:a00J70120:Oo8
j?mY<C9F<^YE2b/k0Y/02V^mJJH9J?QYYAT2n003^3VU00:U0j@3_@0JLkYjb`R;6o[YFkXKmS/KmZFZ
n_JjK<BK3:T3:@06JCTiK3VU0cT00bUIR@03R@08FFTiYFUiJHT2N@AY00B9bJW90ZT01HUiRHUY00>9
0fT02bTi2AT9n2Wf>e/K008k00=K6e/00e/00c]KF`07F`03>e/K009K00<KFe/00e/01A]K>e/k00aK
00B;Fe^;0e/00h]KR`06R`YK00E[Re]K>`06F`046c/K6`9K00<kJe/015/02Q/k6oXKnQ_j6c/2:`06
6b][6f/K0V/02a][Ja/kJa][6b/K00`k00=K>a/01A/00`_jnP02nP8K00?j2`/00P/66`;j00>;JIP0
0YP00kRHV003Z005b6S8b6P00ZP00iRWV0027@052AfhV>P00ZP1J0002Vh04NVaE_H]J_J0QR][EFYF
nXJa00F700F6P>Son002J007NS4bENYEnP02V`0B:jY/J:SoJ?S8n1TYn2Whj:FT0ZD3Y0>m00ec^ZOI
DIXY/F9@VMUG00>J00KYRkXKjF`2Y@03jFTI00@Y00<iYST00ST00bUYJ@02J@>900>U>CT00fT00iV9
R@04J@:900O9PJVYRGV9009i1HT2J@8Y0QT22@07:OSh:OPY6@03:@03>FVU00:U00=YK6T00V`2:@=/
1fT5>@046BTY>@9Y2:D2J@04YFVUP@SY00>1VHT018T017V9JHT2Y@06JJEYYEUY0ST7:@03K6VU00>U
0UT022WHZ6RXV;PM4bd01Ad]^1fh00;800GXn6chj002n0036BTI00?800>XJ6P01fP00omXJ003J003
V:RX00MX00JHZ9RhV;P2Z09X0/P00fS8Z003V00:7IP97@TM^9SXZ05X000:KP03HXL]00:700H]Q[66
;FP3/@:61XL02F:0b?mXonVK<P03jP0<EKf0YAWh2MPYj1TY0^P2n0052OS8>H000ZD01:BUY:@2_@0?
Lb]@J:L9oh:NjIUMGQVW00;Y00^jV]VmYLCYYF`96@03:@04>BTi>@DY0WT2R@03JHUY00AY18T3J@:9
00>1bHT00XT2F@9Y00IiRHV9ZHT2J@8Y00@9:OSh0RT02OPYn2Wh>BTiJ@03Y@04JFa/:@9Y00DYJBUY
:@05J@09YFTi>BTi:CTY009Y2:D00fVUJ@02J@>U1>T00oTZj@02f@03bIVI00F900RURHUYYHUYF@9Y
0ST7:@04>JFUR@:U00Xi2LRXJ:RhV;PM2Rd012T];AT6;@077KRh^<Shj003n0@Y00GXn<RXb00AJ003
Z6QX00EX19P02ZRHV:S8J<QXb6P2Z0:H0ad00iPM:@02^0>X000:KP03jBf700>700Ba;EIE0UH00eD[
E@07Q`09H^W8J?nVVoIF009E00J0_I_YofP2>@036ORh00890^P01JSHb:PI00:000BUY:FU0j@2_@0;
:b[HJH;HZEj2bIh00^T03hIj:]V2:X:IYORUb0TI2@03:@03>BTY00<Y00DI:AV9b@02R@9I00=YNFT0
1HT3J@05RH69PHT01FT00eUYJ@04R@9Y0RT00aTY:@02:@04n2TYn08Y00?XjNT012X02>V0YFTYJBUY
1^T0280ZjEUY>BTi0RT2J@>U00[YP;XKnR[YJJJU0VT00jF1j@02j@03P7XZ008Z00?ijNT01=T3j@04
bH7ij@?900F1bJDiYP05:@06K:GYYNW90ZD028WHZ6RH2OP]1BT00f@Y:@04:@03I2T]00H]0RT00aTY
:@02YP04JOQYYP9Y00BVJCWh0ZP3J004n;Rhn0EX1;P01?SX6AT5J003Z9RH00>H0ZP01FS8J<QX00:X
19P37@032AdY00;X0ZP000Y^00>6;HL00bd02XNaj_Gf32_f:k46Q`07H^VXJ?l;V`02E@03Z[ec00:K
00[;JMQ/Z=PI:CWh0ZP02<ShJ:R7EX2U1J@02;f0LkfHZ6Ti0Rd02HN6HfiELkec6`02Y@09^WZ2P^W:
:QT900HY00Ch:BT90RT026V9RLUYYFUI0fT2R@03NHUY009Y00BURH690fT01eTYFFTYNFT00hT2J@LY
00<i:CT00RT00oPY00070003RbTY009Y00>U00001`02Y@9Y0ST3J@03jE/000P000CfNZEY0jD2j@h0
00<<bGX02002>@07K2TY:F`Ym@070004FJRXfQ401Rd00iT000060003:@0000H00ZP2J0D000FjJ?mX
^0070005mFQXJ:P00iP01ZRHV9QXZ09X0/P016S8Z:P2V0037IPM008M00@Yn;Rh0ZP000Y^00>7;OH0
0XL02_H[QhJa;EJaQh07Q`08H/VWonT0P:@2_@07EOFKJl]EJ003Z003f0Vh009X00RHn6QXjH1FP0:T
00B0Y:BT0[d017>YV;P22@0;6H1S@4F0:g>mD5D00[d01e1EjNUj2bX00PT01OPYn2Wh00<Y00@9n1TY
0VT3R@03YEUY009Y0XT027UYJFV9NHVY0XT2J@8Y00@i2BUI0VT3R@03FFTY008Y00<i:CT01BT00cTY
Y@080006mFaYJJGY2@04Y@05>FUYYOH03P02J@:U00?Yn@003@000oGYNP080003JCU/00DY00?;0000
1@000fUXJ0090003V@0000H01Rd00kX000060003b5/000H00ZP2J0D000G;J6QXZ0070007nVQXJ:QX
Z005V003J:QX00;800AXb6RX0YP021fH;AfH2KPM0^P1b06X0006KP0=6VhJ6XL]b`cj<L]FQ`02;@04
P6RaHPN700MRZJMMmH2600:T00BmVi^;0V/02L]YYh9MjCT9V002j007ofQFjUJ0EP02Y003P;fT00:m
00YcP1TI;EeTKU3I0UL01gBmYJAdP;d017@01>UEboT22@8Y00H9:BWX:OP4:@9Y00B9PHV90UT4J@04
RGV9N@:900BYRH690VT02aTiFCTY>FUiRJF9009Y00hi:CTY>FbV>FbV>BTi:PT00ZD00fVUD00900NU
4@000nVUP@02j@h000?;nGX01`000`aYK002K005:Fa/K?H01`000fVXfP080003VBd000L000M[^S8b
bWh<00L000>jj9X01`001?RXJ?T60004Z6QXJ@L000<ZJ6P00ZP5V009J9QXZ6S8J<QX00:X0iP00afH
7@027@05:KSXj<P00JP000=^00XJKQXJjF?YQbf60_X02hIFjR/<m@3fJfZa00J700F0:OnUnP02Y00@
_E1[Ji]E6f^KFfSXn8UMY`=M00R2<S4bP6YE_@B00[d037>YGEf2I>TZ_ENYP@Bm011d_GAdjGA@X9XK
ZATY2BWh12T01@TYn0TY009Y00BYRHV10XT00fV9J@03R@04NHV9R@:Y0XT2J@06>BTY:CTY0VT2R@03
YEUY00@i00BV:BVV0ST012Ti:E/90005:VUYYOH02@000h2UY@03YA<000CYYLWY3P000oGi^P070003
33U/00<Y00A/:FVK1`000cVX00070004Rbd]2aD000?Yb:T01`001:JXJ</60004ZFQX:@L000BVJ6QX
0ZP6V007J:QXJ<QXb002Z0BH00T]V1fH2KSX^>P00JP00004KQY^6PES00b6/H0<boG;mUGZReD2EP03
jXJa00F700N6H_SoRH2T00:m00@[Ji]E0R/04I/;JnWoK1WhJ?mXf38a<UF0009E00Z0_H20EH1cEEdY
0h801RZU_CB7j@:m00VU_KdZD7BmM>T00ZD3>@036BTY00@Y00@9:BT90RT2J@05RJVYRJT00hT00jV9
R@05R@>Y00B9JFTY0ST00bTiJ@02J@03ZHV9009Y00hi:BVVK3VUYSU/>BTimPT000@KJJFU2P000eFU
Y@02Y@03m@00018000>UjOT03P000l/ZNP07000436U/:@9/00@YJJG;1`000oSj000700@]5@000lSX
f0070003jFQX00L000AKJ6SY1`02J003b6QX00:X0YP016RHJ:P2J004b6S8J0:X00fHYiPMV1fH7ISX
^:SX006X00026PAS00e^VGVI;H1EP69ZEV8]00>a00AF:hH]1HL01HJ0Z6R000>m00=E:`/00W<01R/K
6kdKF`9X00Ei2IRXj@02<P03jUFj00AE0X001jZmEG<In3T00VT01jDZYJYFHjD00kd02jYdM;gInBYG
jKfU008I1bT013TY:OP2:@07>FUYRJV9Y@0:R@:Y0XT00eUY:@03:@<i00MYNHVUREUY008i00NU>CVU
>JHi00:V0ST;009Y00?Y000020001E^UYJF001D000<KjOT03P000oGiNP0700033:HY00=/0VT00jGf
00060003F@0000H000Ei;AdM;@0D00046mShn0L000<ZJ>T020000fSoNP070003J<So00=X0ZP4V007
J:QXb6S8J002Z0:H00<MV1d00YP00afHV003j06X00000f?YKP02V@05NEUIFHH00bd0181FHRd2Q`8]
0[400nZ6;@05Q`06H^UXZ:FT0[d2E@9c00=E:eD00[d02eFK<IPIRF=n<Wjj00=E00FjENYED002_@0P
D7<9V2TINCWY:ZEcEBjU_H6mD;fUJMU^^T2UI:DI>BT4>@TY0fT3N@AY00]iJFUiJGUYRFUiJ@03>@05
:FTY:CT00VT2R@:U0ST026`iK6`iYSTY0cT00jH0000900:U00=@00002@001:BUjOD90003Ve][00X0
00?Yn@003@000`ci^P07000332TY008Y1:D00l/000050003300000D000@[;IRa0Rd00gX0000A0004
JMSH2@L000<KZ=X020000gUXnP060003m/QX00;816P01JRHJ6RX00=X00?8J6P00ZP4V08M19P00jRH
Z001Z0000Vh019USFET2:@0@7HJaP00<boF6EF_Zn^X[E@N700ERjFS8Y003_@06LkfmEB]E0[d01JY@
_B^j009T0S82OP03<UGZ00AE00<KEH000W<03BUXj6bUPOVYjJ@[LlT01;d04GCY:F@JFFA^_L^j>FTi
YSVV008i00=Y:BT01RTAJ@<i1RT2>@0DJEVURFUIJF`iK:I/YSVV>JHY>H4;0003^ZGf00/000?YY:@0
2@000jEYK002K003m@0000H000=jn@001`001JUYFH7900;i00<ZNP001P000`bj^P02^P05bU2UYI/0
3P001OJh^2dM00<]2003b`P000GH2OSH6`0600036jP000P000=Koc/01P001<[8K?l2b0EX00JHJ:QX
b6P2b003J:RX00ZH1:P0000?VGUIFATY2AdYQk40E[4]008[00R0Rf^;Jc^j/@J700ARbOlY1kd00b^m
Y002_@08LkfT_A/b@6h2<P06O[[Z2nYE0`/04Q/[_HVh>FTiYG?jfNUcJg>U:@:U00NmM1WhFBeI009T
00I@N/UY>JH3>@=Y00@YJATI0RT02CTY:CUY:FTYJ@02>@04:FTiJ@<i00<Y>CT01bT01SVVJFV9P@:U
00YI>JE/>JDYYSTY0ST00jFj000;0003Y@0000X00Z@00jX000060003YFU/00A/20000e_i00070003
RFV900;900@ZnBZj3P02Y@03b`0000`000AjV;RH0Qd00bdMb`06000432dMV@L000Ij2MShf=X60003
mZP000T000=XmP001@000jG8o`02b003olS8009X00C8J:RX0VP01LQXJ<RX00>H00<MV1d01IP4Z000
00IiFETY2AT2^00:n8L]3>Z6P?H[QP>a00@]H_Za1XL0181IobT2_@03Y;fm009c00>mY:@00kd3Y09c
00?jKS800S800k[ZE@02E@8;00<KJkd00ST02QVUYFV0L_ZY_H02L`0B>Bh^>Kf1j;PYKVY^PU00^RVV
0cT01FTi>CUY008Y00=Y6BT00bT01VTY>FTYJ@8Y00<i:BT00bT00cTY>@09:@8i00EYYJF9Y@02>@03
K3U/00Di00AY>JHk30000jD0000:0003P:@;00P00VT5K003^P0000D000?;j@001`002JUYRH79:_TZ
NP0=0004bjFUba0000AiV;6H0Qd00h0000050003FAfj00L00]P010WH2LT6000330T000T000<9m@00
1@001BUXb6aX00;800Kob6SoJ<P2J005b6QXb6P00ZP9V0BX0FP00005:ATY2AT00kP012f7/EH2000;
3?Z7nX0]/HH[J[401XL01H1YofSh00Fm0j@3_@:U1:@01W?Jn_XbEP8;12/08G=IZ>RUJJDIY>Vm^WYE
YKfT;DDQJKfUZ?P9bBXEjD1NJ@03>@=Y00DiJFTYJ@0C:@036BTY008Y00Kh:BWh:OP3:@05K5VUYH40
0ZD2J@E/0ST01:HiYCT600033</000@000=K00000P02m@H000>ZY5001`000l]YY@05K003NP0000D0
00?;j@001`001ZUYRLWYn@8Z00>j00002`001<^UYL/A0003:IRh008M00<]00001@000bZh00060007
m/SXj=P9J@0700032`00008000?e00000`000c^;00050009b6c8J6c8J6aX00;80VP01JQXb:S800:X
00?XV9P00YP00afH7@02V004Z9RXZ09X000012TMn1d2^004V:P9Q`:a00>6HXH00[401R/<bh0]/@R7
00IR:FRXV:D3_@:T1;d4Y009_JFUYG=EJi][00:K00T[6eFU:@WXJJD00Z@07jF0K;g:^S_YLcT^AB5I
M:FHn6@96FjU@6BVJJDiYFT00cT01RUY:FTYJ@8Y00=Y:FT00fT01SUYJFTYJ@8Y0aT012TI:OP2:@03
>BTY008Y0VT01:F1PH42Y@EY00M/YCUYYSVV00L000?J000020026`H000>;Y0/01`0010aYYJD4K003
ZP0000D000?ej@001`0018UYRLT2n@8Z00=j00002`001<_YYI/B0003Z9Rh00:h00?e000010000oZH
00060004jFc8j0;h00<Y00002P000b[f000;0003olQ/00?800A/J6co0/P00fS8Z006Z004^9RH7@JH
0ZP3J0001[P00jRH:@02Q`0</HJ0QUJ0/HM[3<]F1hL01hJ06IPYn1T00VT02:GYY;fTPFaY0ZD2J@04
RGTi:@:U00bTD;gYYBW8ocTY2FT2Y@:m01VUK;XZ^U^U:bTM8DDiP2UXK6TYI6jU@@TI009Y00<iJCT0
0STDJ@8Y00<IJAT00QT2:@08>BTY:CTYK3T2Y@03PJGY00>U0fT01BUY:FTi009Y00<iY@001P000nT0
00080003P?X000D000>KY5002002J@:U0V`00fT000060003RnT000L00hT00nWin@02:P03^P0000`0
0ZD00l/000050003N^Vj00P000JhV9RhV;X60003FhT000H01_P00aWe000:0003Z=X000X000UKb6co
K?m/of`00lP01VS8J<SXb0CX00BH^;RH0Qd4V0EX00001AfH7IRh00:H00>XQbd00V802n[jEV]F/HJ0
JV]F00N700=RP2T00`T00oRHV002o`05V?mXofP01?l011eIF@T2o`=X00K8Z9QXZ?P3Y@0EPNTIY;fU
Y1_I6jZm:kgo;CVUNRUX00:U00ZP@1gh<RYYYJIY13T00fTYJ@02J@03FFUY00AY0XT00gV9N@03N@=Y
11T00bTI:@04:@07>FUYYHVUj@03P@:U00=YYJD016T016aYJBX70003bC/000P000>UP0001@000`bT
Y00800033:FU00>U00>j00001P000m[9000700:900O9jNTZnBYj00L000<<YNT01>T2Y@03b`0000D0
00CYRJD<1`001_RXJ9RXV0H000<<fP001@000a]/n003n08Y00?f00002@000kSY000:0003V/S800K8
00[ob?m/J<RXb>S80^P2^0032IP900JH16P1o`0000>H7KP00YP01jRHV8NaJ`000_D01P0[^UJjE@V7
00L]H^Wh^?S8009X00goJ?ooJ?mXofSoJ:Pi009I00?hJ:P00ZP00fSH:@022@0?f8TZYJAjjJF0Lj[J
</Tk008[015EVkfU_GB;FFbUa9U0J7UKj@03J@05YSTiJBT00fT01UVURFV9F@AY0XT00iV9R@02N@9Y
00@Y6FTi0QT00bTi:@04>@9I00>1YNT01>T:Y@03JJFZ00L000?Y:P0020000jFZ000600:T2P0017ZU
jOD900;Y20001:V9bNT3n@03:WX000H000@<YJGY1JD00oH0000500>U00<<00001@001`VXZ9RXJ?D0
1P000oD000040003jOSh00;h00@YYZKj2P000oFHZ00;0004ZFaXK0G800A/b6aX0lP00oS8j002j006
^0VH7IPM19P2J003Z?mX005X0003V0037IPM00:H00>6/F800V801H1ZH[Z000Ba00<]QXL01HL01V;Y
Z:QXZ0;80jP00fRXV006J004:EUIn0:X00G8Z:Shf002Z004j6bU:@>T0ZD01kd[b^TZEKd00Z@00b]c
_@02V@0;M1g8a6bIAQWY0;X00ST03RUY:CUY>BUYRJF9PJV916T4R@04VHVIN@=Y00Di6AUY>@02:@0;
JCUYJEVUPJG9nBX01>T;Y@03F`0000@000?e:^T020000i^UP0070003P:@K01D000<<jNT020000lVY
b@02j@04:_TZNPP000<;6`/00P/011]jYI/70003^R[f00P000<Yf=P00mP00lT0000;00?h00HYYZHY
>IX:0003>fQX00/00/P01FcoK<Q/00;800Sob6Q/olQXZ0;80nP019PMV1d6V0EX00000iP]V003V0:h
00Z6;K6aQbf7/OY[0_X015F0EX06Q`04P8UX6@=X0jP2b0:X00?8Z:P00VP02jPiNEVhZ9P9b6bH00;h
00HYn2VUYRT2Y00BJF`iJ]WY^YVTP:Ab_JDia:HI0_l02:@b@3Wi_bYY0bT013TY:BT2J@07FHV1PHV1
R@03J@B900BIRGUi0fT01RUY6BTI>@AY00MIJHVUbOWY00<Z1NT8Y@03mP0000@000Ce:^UK1`000gZU
P0070003ZZB001D000=jjNT020000nVIj@02j@04:_WiNPh000>KYL/04P001BWhn?PY00;h30000h^V
YP03YP04>JEYn@X000C9J6Qj2P02b00;K<S8b?m/b6c8K6P01<P2Z003j:SX00:H00<MV1d01IP3J07o
0FP000>H0ad01IP]QRf600F700D[FoKemP020003H[6700B700B0>JQY0QT00oRh^002Z00:J:QXJ<RX
b6RX:@9I00>HJ9P00YP01QUiFCV9n0:U00iYYJBm:JQIN/UjbOmILP>m00f0LX096HHYQf=0=5i1008Y
0cT012Ti:CT2J@05FH6UbH400XT4J@>90iT4J@04:CTY>@AY00EIJFV9Z@02b@HZ1NT01JGYYNVU00;Y
1`001?HZ:VX700?Y1`0010^0P50C0004m^WYf@P000GYbNWI:P02j@03nGX000d000<;YL/04@001OYI
YCUI00<i00>;00002@001H4YYZHi00:V00=YNIT02P03J003j00000L000@<b6aX0lP03fc8b<QXb?m/
olQXb:SXZ002V0037IRH00FH00?oJ6P00fP000<M00NH7IPM:HL]00N70[4018OjnV87Q`05HVT9>AT0
12T01CTI6NSH00:X0VP2Z0=I0VP01NPYHfiS008M00<9FLT00ZD00`Wh2@02V008:WZjEFSo:G<2Y@9b
00JmYAh^P6@2I@05I5T];@T022T2J@03YHV900:100>9YFT016T00gUYN@05J@8Y00IY>CTiJCT5J@03
PLWi00HZ2NT00jGYP0070004VbXZj@H000C;jNWY1`001I_YP80;014000D<jBXZj@080004:/WY:P;Y
00?ijGX03P000c^Ub`0A00:U00=IYJD00ZD00cWi000:0003:JHi00:V00<YJFT00VT:0004Z6SoJ0T0
00F;J6c8K003b004ofaXK0C800=Xb:P00jP4V0037IRH00:H00=XV6P016P000037Bd]00@M00=IQhL0
1XL0181FEF82Q`03;HN700F700=RJOP00QT2:@032BTY008Y00AY:BVX0fP02:QIFBTI:IU^0iT010Vh
:Ad2V0067FD]7ISX0Q/037XYokP]Y:FmLZC4;@9500>aIFD00Qd00om5A@08:@03>FUY00:U00>1RH40
0XT00eUYJ@08J@06>BUY6BUY0cT5J@05RJVUjOT01BX00oWYj@02j@BU00>TYH001`001C/ZjNTk00D0
00BjjJCY1`001_FTY83Y2`l000C;:R[I0^T80003:^WY00CY00?9:P003@000a^UV`0@0003jJFU00:U
00F9YJFUJ@0:0003nZHY00>V00HiYZIYN@`80003^VRX009X00<k00001P000iY/o`03b00<K<S8b6aX
K?o8J<QX0ZP01NRHV9PM00:H00<MV9P00YP4J06X0FP00003;AdM00<I00<]QhL01hL01>X<JhL2/@03
;HN700F700F0JOPIJ002o`9X00JXb=ShJAT4J005n5UI:GT00YT2N@:I00DIb0VXV002^00>FATI;F@I
7FSo^:FHVG82_@0>EC]5<C9T_c9/obgfnVT2:@06>BTYn2Ti0VT02:EYRJF9YFV926T01cUYJFTYJAT0
0ST01FUIFFUI00=Y00F9bNWYn@04:P;Y2JD00kX0000500052b[YjJX01@001:GYjNT800;Y00FTP:B0
R`0;00043;XZ:PCY20000b[Yj@03j@;900=j000030000a]Ym@0>00036nVU00NU00=IJH/02@03n005
6ORVYRT00fT00h/000060003>IQX00;o00>900001P0022[8b6coK?m/0/P026Q/J6aXb6RX0^P01JRh
^1fH008M1IP4J0:X00036@8]0QT00f<]Q`06Q`06/HKf0<^01hL01f:0:OP9J@T00fP3o`06^0WoJ:Rh
0PT3F@0=NETI^5USNFRXb>P9n003Y@04JJBU/@<]00XY^9PYLjFm0?D00X/02OG;0<A/;LYY>@07:@04
>FUIR@:U00J9JHVUFGT2J@03>BTY008i00MY>BTY6CTI008i00=Y>FT01FT3Y@04nBXZ:P?Y00>1YJD0
1jD00kfKF`03R`03JoJj00CY00hkRe][2jGYY>T;Re/KF`8K00_;YNVUY82TP:@;30060003FgXZ008Z
0nT01=W90004308000@ZjNWY0/T2R@06:P0000`01P`01`0<051YR`001``20003Ra^000;Y2JD016TY
:P0630030?Kh00Kh00JV:JIYVP06300309QX00=X00FX000<m@0330060:K8K6Q/0lP01?m/b<P5Z003
b>Rh00:h00JH^9PMV1d3V09X00>XJ:P00ZP000096BTY6BT]:HH]00F700Ja^V:a;HL20003P8N700B7
00YR:RWhojQYbFV90fT020Vh6KQiVETY0UT03BVhZ?mXNF=IZ;Shf6`00RT00jBUY004Y00JQf@]IISo
K:BmLV]KonWfI0c4K1d0mZHi:CT4:@07>FUYJHUYF@02J@03RFUY008i00<Y>CT00ST01bTiJAUY6FT0
0cT2J@03FFTi008i00EYYJFUP@02j@03:_VU00BU00=YYJD01JD4Y0:000>TjJ@00^TCY@03jJBT00:T
00>0Y:@01^T4:P03jB[Y00?900>9FBT00QT2R@03bNWY00;Y0/T01XUYFFVUF@:U1>T2Y@=Y00=/JBT0
0VT5Y@03PJFU00>U00?YYJD01jD00fTY:@02:@?X0_P02<Shn?Q/b?S80oP00aVVYP03:@08Y_SXj:RH
Z9P2J0;o00eXooo8ofQ/J6cob6co00C800=Xb:P01JP01^Rhn?PM:@@M00>h7IP00YP00jQXZ003Z000
1bT00hJ7Q`04Q`0:/B][EEIZQfZj/@F7011RbAVX6OW8bBUjRBYYnVT;0]T01WUjNRUI:@;o00IX^7WI
6JP2f00<n1Wh6JFTYJBUY;fT0^T04f=TIAVmL[d<nVQF339[b6i0V0T00ST01bTi>BTi:CT016T01eUY
JEUYFFT00cT012Ti>BT2>@06:CTi:CTY13T3J@8i0VT01JF1YNWi00;Y0ZD01FVUJJEY00JU1Z@01H2T
jJGY00fU16T4Y@>T0X000nVTY002j@03QRXZ00<Z0nT00mW9V@02J@056FUYRLT01NT01lV9RGUY>ET0
0jD01>VUjNT2Y@03JBTY00A/16T3Y@03RJFU00ZU0VT3:@036NSh00;X00?Hn>P00/P00oS8K003b0Ch
0ZH26@;h00>Xj>P00ZP01IQXJ6So009X0_l01<Sob?l2b008J<Q/ofaXK<P3Z00>b:RXj;Sh^2Wh7KPM
V1d2V0047IRHZ09X0jP00007FHMIQgV7:@02;@J700QRQk6aQbf7HPJ701QRbNShRMYYnOo9:GZXfYRj
^9VXRITYFOP2Z0;H00EiHaUX6@02n0:U0RT2Y0:U0j@05JFTY:F77Rd[0<]EV6h036hMADJh:@04>@<Y
00HiJFUIRET2J@03>FUI009Y0ST00bTi:@02:@06>BTi:CTY1ST01fTY>CU/>FT00ZD0187YjNT4Y@9Y
0ZD00fVUY@05Y@RT1:D00jBUY@05Y@9Y00@iYJEY1:D00nVTY003Y0CY0bX00oTZ:P03j@;900>9NET0
0QT00gV9b@05j@06bGV9JAUY0UT3Y@;Y1:D01VU/:BU/:@AY1jD00nVUj@07Y@DY0^P00oSXb004b0;h
0/P016c8b6`7n004b>RXZ0:H00>XV6P00VP2o`=X00O8ofc8ofco00C800Cob:S80ZP01KSH^=Rh00;h
0[P67@:H00>XV:P01:P00009FFUIFJEIjH2a01B701ERRKP9bOTYVFV96LYY6IVj2GZYn2X00UT02aWh
Z:SHVFhIf2VU008I00JU:CVUY:D5Y00BO81jY80]FO[If1d]@4E1@1hM0ZP2J@04>FTY>@9Y00<iJGT0
0fT00aUYJ@03J@8i00DY>BTY>@02:@03>BTi00Hi00=YK6T00V`01cVU>FV1YH400^T5Y@03JJFU00VU
00>TYJ@00j@01:FTYJ@8Y@04JCVV>@:U0fT3Y@04jJBTY0?Y00F7jBXZn@02:P?Y00GIbIV9J@02:@03
JHW900;Y00CijNW90XT01VT9J@TiF@VU0RT2K007:F`YK6TYJ@0?Y@03JBTY008Y00A/j>Sh0^P00mSX
b004b003n<S800[800>Xj:P019P2J004ofQXJ0;o0VP00lSob004b004ofaXb0>X00Bhf;SH1?P00bTM
^0047@FH00=XZ:P00ZP000BU00^7YHN6jHJ7;K4]/@0=Q`03QV:900;h02AYba]j6e^jmOZ9bkXk^P0<
jAeI^=RX6OQSVETIf:GHb:BU:JD3Y00>YJBTYJBjP:Fmf40]f8T2I00>@390I6cibZTiJCTYJBT2>@9Y
00=IJCT00VT26@=Y00@iYSVV16`013U/>BT4>@9Y0RT01FaYK3U/00=Y00>1YJD01:D01VVUJJEYY@9Y
1jD;Y0FU00IY>CVVYCT2Y@04JJFUY@WY00?9nBX00RX01?TZjNT2b@03RGTY008I00=iRLT00nT00oW9
b@02R@9Y00D9JATiF@08Y@03:FTY00=/00<YK2T00VT6Y@03jJGY00FU00=Y:BT012T3j009f<Shf?S8
j<Sh00c81:P3V004YiQXJ0?o0VP00oo8o`02b003olSo00;800?ob:P00ZP01mRh^?SHn=P00oP27@06
V1fH7IPM0YP2Z003J:RX006X0005Y@04jJFUQ`9i00AjOX260[4<Q`05HVWXJ8T00P02m@0?08_90?H<
bPb9mL_YV5WH008I00Q/>F=^YJRH6@BU0149YJFTFJF0Y2VJJZE/Y2f9J@02KP0<5AU05DD]a5/kVFTi
0VT00cUYJ@06J@03>@UY008I0VT013UY>FT4>@04JF`iJ@<i0VT01:EYJBT4K006YFVUPJGY1JD2J@03
YFUY00EY1JD:Y0FU13T3YP03YFUY00NU00>9QfT00^T01OWY:R[I00?Y00O9ZFUY6@UY00:900OYnOWi
bNW900:90VT46@8i2:D2:@9/00@YK6`Y4JD5:@03K2WX00;h00KHn=SXf?P2b003n<S800[80jP6V0AX
00SoJ6SoJ?o8J0;800?ob6P00VP2Z003^?Sh00;h00?H2OP00_P00kPM7@047@03V0VH00:H00>XJ:P0
0JP000RU00>9YHT00XT029V9:X27/Bfa1hL00f:6b002o`0A:X^jb]Zj:/Wj:VTIZFRYJGT00aT03jDI
Z0USKSU/f:FT6MRUY002Y@04Y:FTY@:T01<;P:FUQonXYFQU@9SoV2fHa0_901EY00IiFFUYFJD2F@05
>EUIFFT01:D2J@04YFTY:@9/0VT:Y@=Y00>UJJD00fT5Y@ZT1:D01VU/K6bU>@BU0VT4Y@AI00>9bNT0
0^T00b[Yj@02j@;900R9NFTI>FV9b@GY0/T01HUY6FT900@I00<YJJD01ZD2J@=/00<YJJD01jD00nVU
Y@06Y@9Y1RT01fcXn?SH2MP00oP2b003n<S800S81JP6V003J?oo009X00SoJ6SoJ?mXo`EX00BX^=Sh
0PT6n008^1dM7IPMV1d4V0BX0009Y@04JHV9R@BI00@ZNX260k44Q`06H^VX^6Wh0ZP01;Sh^6P2o`9X
1?l01ZQIFGTi6@:X00LIKUTIK2WH009/00BXK6aX1V`00jBUY@02Y@086LRUjJEU@<T2Z@08bAdinWYY
:CT3J@=I0VT2N@IY00QiRHVIYHVUJ@jU00EY:FUY:@02J@>U00?YYJD00jD6J@03YFUY009Y1JD8Y0BU
0VT00bU/YP02YP04YJI/>@9Y00>UJCT00cT015V9RLT2j@8Z0nT01MW9ZHUY008900@INHW91>T2b@:9
00XiJ@TI2KSh2ATi2:D01cUY:BUYYFT04ZD00f`Y:@02:@09K2WXn=P9f0WH00Ch0/P00oS8b005b003
Z<RX00:X1iP4J004ofQXo`YX0ZP01]P92@TI2@?h00<M;Ad01Qd5V07X0JP1Z0001jD00nVUR@04R@:I
00FYYH6Uj@02P003QRfa008]011RjBTi2OPI2ORhn6RXn=QX0ol01]ShV9QXZ0;H00=XV1T00RT01:EI
^=P2Y007jBXZRNTZKP02j@096IW9jJT9FJVI009T00XII:VYPUV2>ETi0VT013UYFET2Y@9Y0XT5N@04
RIVIb@BY0X401XV1RJF9P@:U00Z1YJFUJJEY:FVU0VT2Y@;Y0ZD015VUYJD3J@:U00BIJFUi0UT3Y@ZT
1:D01VTYK6bUK0>U00A/>FTY0cT36@04JGW9f@GY00[9jIVYNBT9>BV90/T4j@04bHUIJ@<I00<9n?P0
1?P00cVUY@06Y@03>JEY01BU00=Y:F`01BT01>PIn?P32@?h0^P01?S8b?P2b006Z<S8b:SX0jP00iRX
V005V0QX00?oJ6P016P2Z003^=Sh00<I00<9n?P00_P77@05V1fHV:L00iP1Z0003JD00iVYV@02V@06
PJFUjJGY0X001HH]QaWo00;h00BXoonh0QT01JRhokPI00=Y00RXNLU^NWVINP8b00<K<Wh00S800a/b
<P03<P=^00ASNFAT0RT2I08I00IT6ATII1T5I003FAUI009I00EYNEUIY@02R@>Y00B9ZHVY19T4f@;9
00ZYbLVUbH69PLV11ZD016VU:FT4Y@?Y1:D4J@03YIUY00=Y00=IYJD01:D8Y0FU00YYK6a/YVbV>F`Y
0cT00aWh2@022@03NHW900;I0nT03]W9bLVIJATi6FV9VLWI0^T01/V9NFTY>@8900?h^;P00kP00`Wh
>@0OY@DY00@I:NPY0_P010TI6BT4n0?X1/P00jS8Z002Z003V:RH00:H00>hV;P00[P00iRXJ008J0>H
0kP00mP9n0036@;h00Rh7Afa;Ad]V08M00>HYad00iP1j06h000:Y@03PHVU00BI0ZD00h6UY@05Y@07
jGXZZFV9Z@02j@0>6EV9jHUI2GUIREUibNT2KP03OS8b00db0Vh2H`9T00@YI6@Y0QT01F@I6F@I00=T
00@II6@I0V@01ETIFEUi00:900O9RLV9bIW900;I00=SbFh00mT01b[IfLVYbJT00XT01JG9bH6Y00;9
0ZD01X6UJJDYJ@FU1>T00jEIY@02Y@QY1JD:Y0BU00=Y:FT00f`00bU/:@02:@8i0_P22@046FV9V@;Y
00LZfNW9fNW900:900IY6ATYNJT2b@;Y00G9RHUY6@03n0>h00JHZ9Rhf0T2>AnU00=Y:BT00RT01>PY
6AT2>@036CTi008i0RT01?PYj?P2b004n<RXb0JX00>HZ9P00YP00bfh^002^0FX00=XZ9P01IP2^003
f0Wh008I00H9n?Sh/KP2;@037BdM008M00JH7IRWV:L2V00000>UPJD01jD01XVUZFVUV@VU00AIYFV9
0fT00eV9R@03J@06FHUY6FTI0fT01GVIjNU^00lb00QnKViSKV@YI0LI00AT6F@I2V@00eUTV@02V@05
RLW9fNT02=T00b[If@02f@04ZHV9R@C91JT00lVUY@02Y@03:JFU00BU00GYYNWYY@02F@:U0VT00jEY
J@03J@RU2J@4Y@03JBTY00<Y00@i:CTi0aT22@8I00=iRLT01>T2f@0<jLW9bHUY6BUYRIWY0lT01YV9
NAT9n0>h00BHZ:QX0ZP01KShf2UI01>U00=YYJD02:D00bU/:@04:@036BTi00Di0RT01oPYn?PYj?P0
0/P00jSXZ003Z003J9QX00:H00Vh/IP]Z=RhZ;P00ZP00kRXV005V0>h0]P42@04f?P]^0<]0Qd00iPM
V0027@03YadM00:H0NP00008ZJFYPJF1YH46Y@03VJFI00:U00>1YJD01:D00fUIJ@05J@04FFUYN@=I
00QY>GTIJHUiV@;Y00=^OS803S83KP08HeUT6F@Y6F@66@03I1UT00UT00fIKVkYbMWYfFhZ6VhJ00=^
010JKR[IKYVYNEV9NHW9RJV90ZT01<V1jFT3Y@03:JFU00BU1>T3Y@03JJEY009Y00>UJJD02jD6Y0FU
00@i:BTY1?P56@062AT9JHVY1^T02=WYbNVYRCTI0VT018W9bMT2b@04RGTI2@>h00NXV:QXV6RH00:X
00CH2OPi4:D00fTYJ@02J@ZU00=Y:BT00bT3>@FU00<iJCT00bT2n004j?SHb0>X00=XZ:P00jP01kP]
V;6h;KP00]P00lSHZ002^0NH0[P00mRhf002f0:h00?H^2d01ad2V0037BfH00:W0@T1V00000B1ZJVI
0ZT01lVURH69JH400ZD2R@NU00=YYFT00fT00eUYF@03J@06NCUYNEUY0UT01fV7FHO9jFh00Wh?<P04
KQYSH`=I0aT00bTI6@026@03FATI00]T00A^jF?I0QX00fhZKP03KP06OVi^KRXJ0]T00f=iI002F@9i
0XT01ZUiZFVYV@:Y00?9YET02:D3j@NU00=YYJD03jD5Y0>U00<i:AT00_P42@036@TI00DI00J9VLWI
:]T2j@07fNWYjLV9F@03J@:90/T2j@:900AY>NRh0YP016RHJ9P3J005V:Rhn0T00ST6Y@03jJFU00BU
00=YYBT00bT00fVUY@08Y@06JCTi:CUY2JD2J@<Y0_P01>S8b<P5Z003V:Rh00:H00Bh/Agh0[P2f003
n=SH00:h00@MV9PM0iP01Afh^;SH00:h00?h^2d00YP011fH7Bd47@03;IRW008M0IP12@6H0004j@03
fH6100J100>9YJD00jD01869YFT2Y@9Y00=INGT01FT015UYNFT6F@:900IiVNWYKWh><P08OVhJHiUI
I2T56@05:AUI6F@00UT01VAII6ASI0]^1Gh00c9^<P04KP=S00AI:EUI0WT02IV9VEVIFJVIb@02R@9I
00>UFJD00jD00nVTY002jAjU0UT02STI6ORhf?Rh2OP62@03RGWY00[Y0/T3J@03FHW900?90XT01GTi
n;RH009X00>HJ6P00VP02IQXJ9RX^=PI>@04Y@03jJFU00FU00=Y:FT012T00faYY@09Y@03>JEY00:U
00=IYET01JD00fVUY@02>@05:AWhj=P00ZP2^00;V;RHV;RH^;4M^;400[P2f003n=SH00;H0[P8V006
7IP]^1fh0YP011fHV1d3V08M0YP27@042AfW7@4900001R[inB[ij@;i0^T00h6Ub@03P@:U0XT00jF9
Y@04J@06RFUYFFUi16T2>@0:JEUIQeV7FGV7b@;Y00=^<S803S82KP9S00YT:F@II1UT:F@Y0eT00gUS
H`02H`Y^00=n<Wh00Wh01c9n<WhbOS8016h00aYSI002I00>6FAIHiUiVETiVFBIHjT2R@=I1:D4jAjU
0UT00cTI2@03n0:h0oP01=P92@T2J@04RLW9j@8Z2>T2R@05>EV9RJD01<T01HUYn;RH00YX00NHZ;Rh
n0TI00>U00?YYNT01JD01FVUJBU/008Y00A/:BUY6:D026TY:BWXn=RX0kP3V0:h00VH7KP]^;6hf;P0
0]P3n003f;Rh00:H00<MV1d01IP00afHV006V0037IPM00<M00FH7AdMV0027@490Ad1V0000gX00bYj
:P05:P03nNWY00?Y00G9PH69P@03R@04JHUYN@=Y00LIJFTi6FUi00QI00=iVNT00Vh00ghb<P0=<P9^
0V<00eUTI002I003:F@Y009I0WT4V@=S1Fh00c9^OP02<P03OS8b00Lb00=^<Vh016h4I00::FAiHgUI
I5UTF@:I00=SVLT00hT00jF9Q`03j@03Y>VU016U13T00eVUF@02F@05YEUIFAT00PT00oRh^004^004
7OPIn08900PYJIW9jMWYn@OY0/T015VUJFT2R@?90XT016T9^:P4J005ofQXJ9P00VP2V0:h00CH6CUI
2JD00fTY:@02:@04K1TYK08Y4jD00fVUY@03>@03:ATI00;H00>X^:P00YP03KPM^1fH/KRa^;6h;KP0
0]P00oPIn002f003^;6H00FH00<MV1d00YP011fHV1d:V08M00BH7AfH0Qd2^00000>J^[X00YX5NP03
P7XZ008Z0oT3j@;900>YRHT026T00cUYJ@02>@II00>7RHL00/T00aXZOP0?<P03OViS009S1f@2H`>I
00ASfMTJ16h0139^OWh2<P03OS8b00Xb00=^<Vh00Vh016=TI1T4I09S0UT00fAII002KP05HiVIVGT0
0YT01<V9bHL2R@bU1ET01aUY>CTI>BT00cT011Ti6AT32@077ORh^1fh7@02^0097KSh7OPINHW900;Y
00<ZfNT01^T2b@04PFVUJ@:900>UbLT00XT00`WhV002J003ofQX00EX0YP02:RH^;Sh2ATi1jD2J@8Y
00E/:BTYK003:@03JJFU012U00AYYBTi12T2n0;H00>XV;401;P00afh;@06;@04V2fhf0;h00<I2MP0
0[P011fHV1d5V0047IRH7@jH00LMV1fH7IPM006H0007^P09V[YjNVYjJX1j00<Z0_T00nW9b@03R@AY
00<YJFT00RT01CUY>ETi00II00J9NNWYKWh?<PA^1f@016=^KV<2f@036VhJ009^0Wh00c9n<P0@<P03
OS9^009^0V<7I005NEUTI1T00V@3KP04VFi^H`FI00>9bHT00eT01JEIYEVU00MI00@I>FT90QT00cT9
2@042@09:@Wh:KP]n;PM00Fh00/M^;PM^0TYJIWYf@06j@03fB[Y00;Y00K9RHUYRJD4b@05RFT9^9P0
16P00omXJ002J004V6RHV0Bh0_P00cVUF@05Y@04JBUYK08Y00A/:BTY0V`00bVUY@0?Y@03JJDY00@Y
00CXf?SH0ZP2^0:H32d00k6hn002f0046OSHf0:h0YP021fH7IPMV1fH0Qd00iPMV00=V0037IPM008M
0[P000fj00Aj^WYZ0gX01b[inNVYRET00fT02SUY:BUY:FTYJCT7F@06RIW9jFin3c800gi^KP02KP04
HfASI0Y^0Wh00c9n<P0B<P03OS9n009^00DJHf=T6@03I00>FF=SI2UT6FAII6>IHgT5F@Ei00=Y6FT0
0QT6F@0<:HMI:ETY6OPY6OPM0QT00kPMn002^00A7KRh7KPM^1fhn;PM^9Rh7BT00QT01JVIjNTZ00;I
0nT01=WYjMT2j@?900>1bLT00lT015UY^;P3J0;o0VP01omXV6RHZ9P00[P01Qghn0TI>@JU00=Y:BT0
0RT01F`Y:BU/00<Y00=YYJD03ZD5:@0=j1Whj=RXJ:RhV1fa7@08;@097Bd];KSh^0Wh00?H00?h^1d0
0YP02QfHV1fH7IP]V1dAV0047KRh^06H00000k[:^P06^P03b[Zj00Jj00Qj^WYjnNV1R@=Y00@YJBUY
0ST01bTi:FTiJCT00fT023UYFHWYfBYn438>KPAn6382OP=^00ISKUUT6BT3I003NFAI008I0V@01eUS
I7UT:F@00bT01QTY:BT9:@D900<I:FT00RT015TY:BT3;@8I00<M6Ad031d2^005n2fh7KP00ad02KPM
2EV9bNTZf@02:P05jMTZ:]T00RX3j@;900[YbNWYbHUi>KRX1FP00omXJ002J005V:RH^1d01;P00oP9
6@02>@>U0VT00f`YK003:@07K2TYK2UY:@0=Y@04JJDYK0@Y0nP02=RXZ:RhV;6h3bd01kShf=P9f;P0
0iP00afHV0027@06V1dM;IPM3IP00onHV003V0037KRh006h0005^P;:1KX00lZj^P05^P9j00@ZbLV9
16T:>@07JCTi>FUIJ@03R@03fFin010b00=nKVh026h2OP03<Whb01/b00=nKVh00]T01ViI:BTI:@AI
00@I:ATI0V@01V=II1TY7@<I00dY6ATY6OPIn1Wh6BWh00<Y00@I:AUT0aT;7@03V1dM00HM00>h7KP0
1KP03OP9NIW9jMTZjB[I:^T00RX00nTZj@04j@0@bNWYbIV9:ORhV6SoJ?mXo`AX00>XV9P00kP01ORh
n;Sh008I0ST2Y@06JBTYK2U/0bT4K003JJFU00fU1bT00fchf002Z09X00>H^;P03bd011d]^?P3f003
^;6H00:H00/MV9PMV1fH7BfH7@0CV06h0IP1V00000K:^[[:^/X4^P03b[[:00;:00>jb[X00[X2NP04
nNVYR@=Y00DiJCTi:@03>@8Y00<i:CT00cT022UYFHW9jBY^4C86KP8b00=n<S807S8037hbORXJjHUi
FBUI:@=I00DYFATII002F@9T00=I:AT00QT011dI7AT67@03n1Wh00@Y00dI;AT]6BdI7F@MI1eT00<M
00<]7Bd021d01kPM^1fH7IP00Qd01SUIRLWIj@8Z00?I:RX00bX00nTZj@04j@?90hT016T9:JP;J003
Z9Rh00:h00T]^?Rhf?SH2AT00ST01ZEYJBU/:@=/00<YK6`00RT00fVUY@0<Y@03JBTY00DY00?Xf6`0
0ZP016RX^;PB;@;h00>hf;P00[P01QfH7IPMV0DM00>H7IP02YP01OnHoiSo00JH0FP000:j00?:^/X0
0[X2bP06^/[:b[[:1KX01WXZnLVYJ@AI00HiJFTiJBT9>@=Y0XT00nU^OP0A<P9n00=^<S809C800gi^
KP02j@07HhUIJAUIJ@03F@8Y00MI:EUSNETY008I2Ad00kPM^0067@04;ATI;@@I5ad02IPMV1fHn2Ui
Z@02j@04:^TZj@@Z0oT2j@;918T01WUY6@VhZ09X00GoJ?mXo`03J0:X00>H^:P02;P00mP9n004>@03
JBU/00I/0RT00fVUY@0<Y@03JBTY00DY0nP01VaXZ6RXV1@]00>hn;P00kP5V0077IPMV1fH7@0EV0=X
0000\
\>"], "Graphics",
  ShowCellBracket->False,
  CellMargins->{{0, 0}, {0, 0}},
  Evaluatable->False,
  CellLabelMargins->{{1, Inherited}, {Inherited, Inherited}},
  CellFrameMargins->False,
  ImageSize->{358, 193},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  Background->GrayLevel[0],
  CellTags->"Top"],

Cell[TextData[{
  StyleBox[ValueBox["$FullVersion"],
    FontWeight->"Bold"],
  "\nRegistered Name: ",
  ValueBox["$RegistrationUserName"],
  "\nOrganization: ",
  ValueBox["$RegistrationOrganization"],
  "\nLicense ID: ",
  ValueBox["$LicenseID"]
}], "TopMatter",
  CellTags->"Top"],

Cell[TextData[{
  "\[Copyright] Copyright 1988-1996 Wolfram Research, Inc. Protected by \
copyright law and international treaties. Unauthorized reproduction or \
distribution subject to severe civil and criminal penalties. ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " is a registered trademark of Wolfram Research. This About Box is a ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " notebook.\n\n\n\n\n"
}], "TopMatter",
  LineSpacing->{1, -1},
  CellTags->"Top"],

Cell[BoxData[GridBox[{
        {
          ButtonBox["Help",
            ButtonFunction:>(FrontEndExecute[ {
                FrontEnd`HelpBrowserLookup[ #]}]&),
            ButtonData:>""], 
          ButtonBox[\(Contact\ Information\),
            ButtonData:>"ContactInformation"], 
          ButtonBox["Credits",
            ButtonData:>"Credits"], 
          ButtonBox[\(License\ Agreement\),
            ButtonData:>"LicenseAgreement"], 
          ButtonBox["Top",
            ButtonData:>"Top"], 
          ButtonBox["Print",
            ButtonData:>"ContactInformation",
            ButtonStyle->"PrintButton"]}
        }]], "ButtonBar",
  FontFamily->"Helvetica"],

Cell[" ", "RedRule"],

Cell["Contact Information", "SectionHeading",
  CellTags->"ContactInformation"],

Cell[CellGroupData[{

Cell["Main Web Sites", "ContactHeading",
  CellTags->"ContactInformation"],

Cell[TextData[StyleBox[
"http://www.wolfram.com\nhttp://www.wolfram.co.uk\nhttp://www.wolfram.co.jp\n\
\nNote: All services listed are available at all of these sites.",
  FontColor->GrayLevel[0]]], "ContactText",
  CellTags->"ContactInformation"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
  "Information about ",
  StyleBox["Mathematica",
    FontSlant->"Italic"]
}], "ContactHeading",
  CellTags->"ContactInformation"],

Cell[TextData[{
  StyleBox["General and sales information\n",
    FontWeight->"Bold"],
  "info@wolfram.com\nhttp://www.wolfram.com\n\n",
  StyleBox["Frequently asked technical and other questions\n",
    FontWeight->"Bold"],
  "http://www.wolfram.com/faq\n\n",
  StyleBox["Documentation updates\n",
    FontWeight->"Bold"],
  "http://www.wolfram.com/book-updates"
}], "ContactText",
  CellTags->"ContactInformation"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox["Services for Users",
  FontSize->14,
  FontWeight->"Bold"]], "ContactHeading",
  CellTags->"ContactInformation"],

Cell[TextData[{
  StyleBox["User registration and password requests\n",
    FontWeight->"Bold"],
  "register@wolfram.com\nhttp://www.wolfram.com/register\n\n",
  StyleBox["Installation support and bug reports\n",
    FontWeight->"Bold"],
  "student-support@wolfram.com\n\n",
  StyleBox["Technical support web site\n",
    FontWeight->"Bold"],
  "http://www.wolfram.com/student-support\n\n",
  StyleBox["Mathematica",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  StyleBox[" training information\n",
    FontWeight->"Bold"],
  "training@wolfram.com\nhttp://www.wolfram.com/training"
}], "ContactText",
  CellTags->"ContactInformation"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox["Comments and Feedback",
  FontSize->14,
  FontWeight->"Bold"]], "ContactHeading",
  CellTags->"ContactInformation"],

Cell[TextData[{
  StyleBox["Suggestions\n",
    FontWeight->"Bold"],
  "suggestions@wolfram.com\nhttp://www.wolfram.com/suggestions\n\n",
  StyleBox["Bug reports\n",
    FontWeight->"Bold"],
  "student-support@wolfram.com\nhttp://www.wolfram.com/student-support\n\n",
  StyleBox["Comments and feedback\n",
    FontWeight->"Bold"],
  "comments@wolfram.com\nhttp://www.wolfram.com/comments\n\n",
  StyleBox["Mathematica",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  StyleBox[" Archive\n",
    FontWeight->"Bold"],
  StyleBox[
  "Publications and other nonproprietary Mathematica related \nmaterial  is \
welcome at: \n",
    FontSize->10,
    FontSlant->"Italic"],
  StyleBox["\n",
    FontSize->9],
  StyleBox["The ",
    FontSize->10],
  StyleBox["Mathematica",
    FontSize->10,
    FontSlant->"Italic"],
  StyleBox[
  " Archive\nWolfram Research, Inc.\n100 Trade Center Drive\nChampaign, IL \
61820, USA",
    FontSize->10],
  "\n",
  StyleBox["\n",
    FontSize->9],
  "archive@wolfram.com\nhttp://www.wolfram.com/archive"
}], "ContactText",
  CellTags->"ContactInformation"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
  StyleBox["Mathematica",
    FontSize->14,
    FontWeight->"Bold",
    FontSlant->"Italic"],
  StyleBox["-Related Products \nand Material",
    FontSize->14,
    FontWeight->"Bold"]
}], "ContactHeading",
  CellTags->"ContactInformation"],

Cell[TextData[{
  StyleBox["Mathematica",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  StyleBox[" Products Catalog\n",
    FontWeight->"Bold"],
  "http://www.wolfram.com/catalog\n\n",
  StyleBox["The ",
    FontWeight->"Bold"],
  StyleBox["Mathematica",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  StyleBox[" Book\n",
    FontWeight->"Bold"],
  "book-updates-responder@wolfram.com\nhttp://www.wolfram.com/book-updates\n\n\
",
  StyleBox["Mathematica",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  StyleBox[" Bookstore\n",
    FontWeight->"Bold"],
  "http://www.wolfram.com/bookstore\n",
  StyleBox["\n",
    FontWeight->"Bold"],
  StyleBox["MathSource",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  StyleBox[" Electronic Library\n",
    FontWeight->"Bold"],
  "http://www.wolfram.com/mathsource\nftp: mathsource.wolfram.com\nmail \
server: mathsource@wolfram.com\nadministrator: mathsource-admin@wolfram.com",
  StyleBox["\n\n",
    FontWeight->"Bold"],
  StyleBox["MathUser ",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  StyleBox["Newsletter\n",
    FontWeight->"Bold"],
  "http://www.wolfram.com/mathuser\nmathuser@wolfram.com"
}], "ContactText",
  CellTags->"ContactInformation"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox["Company Addresses",
  FontSize->14,
  FontWeight->"Bold"]], "ContactHeading",
  CellTags->"ContactInformation"],

Cell[TextData[{
  StyleBox["Wolfram Research, Inc.",
    FontWeight->"Bold",
    FontColor->GrayLevel[0]],
  StyleBox[
  "\n100 Trade Center Drive\nChampaign, IL 61820\nUSA\nemail: \
info@wolfram.com\nphone: 217-398-0700\nfax: 217-398-0747\n\n",
    FontColor->GrayLevel[0]],
  StyleBox["Wolfram Research Europe Ltd.",
    FontWeight->"Bold",
    FontColor->GrayLevel[0]],
  StyleBox[
  "\n10 Blenheim Office Park\nLower Road, Long Hanborough\nOxfordshire OX8 \
8LN\nUNITED KINGDOM\nemail: info@wolfram.co.uk\nphone: +44-(0)1993-883400\n\
fax: +44-(0)1993-883800\n\n",
    FontColor->GrayLevel[0]],
  StyleBox["Wolfram Research Asia Ltd.",
    FontWeight->"Bold",
    FontColor->GrayLevel[0]],
  StyleBox[
  "\nIzumi Building 8F\n3-2-15 Misaki-cho\nChiyoda-ku, Tokyo 101\nJAPAN\n\
email:  info@wolfram.co.jp\nphone: +81-(0)3-5276-0506\nfax: \
+81-(0)3-5276-0509",
    FontColor->GrayLevel[0]],
  "\n"
}], "ContactText",
  CellTags->"ContactInformation"]
}, Open  ]],

Cell[BoxData[GridBox[{
        {
          ButtonBox["Help",
            ButtonFunction:>(FrontEndExecute[ {
                FrontEnd`HelpBrowserLookup[ #]}]&),
            ButtonData:>""], 
          ButtonBox[\(Contact\ Information\),
            ButtonData:>"ContactInformation"], 
          ButtonBox["Credits",
            ButtonData:>"Credits"], 
          ButtonBox[\(License\ Agreement\),
            ButtonData:>"LicenseAgreement"], 
          ButtonBox["Top",
            ButtonData:>"Top"], 
          ButtonBox["Print",
            ButtonData:>"Credits",
            ButtonStyle->"PrintButton"]}
        }]], "ButtonBar",
  FontFamily->"Helvetica"],

Cell[" ", "RedRule"],

Cell["Credits", "SectionHeading",
  CellTags->"Credits"],

Cell[TextData[{
  StyleBox["Original concept by: ",
    FontWeight->"Bold"],
  "\nStephen Wolfram\n\n",
  StyleBox["Front end concept by: ",
    FontWeight->"Bold"],
  "\nTheodore W. Gray\n\n",
  StyleBox["Kernel language design by: ",
    FontWeight->"Bold"],
  "\nStephen Wolfram\n\n",
  StyleBox["Version 3.0 kernel lead developers:",
    FontWeight->"Bold"],
  "\nVictor Adamchik\nAlexei Bocharov\nJerry Keiper\nRob Knapp\nDan Lichtblau\
\nBo Liu\nMark Sofroniou\nSirpa Saarinen\nAdam Strzebonski \nTom \
Wickham-Jones\n\n",
  StyleBox["Additional senior kernel developers:",
    FontWeight->"Bold"],
  "\nRoman Maeder\nOleg Marichev\nBruce K. Smith\nMichael Trott\nDavid \
Withoff\nStephen Wolfram\n\n",
  StyleBox["Front end language design by: ",
    FontWeight->"Bold"],
  "\nTheodore W. Gray\nNeil Soiffer\nStephen Wolfram\n\n",
  StyleBox["Macintosh lead developer: ",
    FontWeight->"Bold"],
  "\nTheodore W. Gray\n\n",
  StyleBox["Microsoft Windows lead developer: ",
    FontWeight->"Bold"],
  "\nTom Sherlock\n\n",
  StyleBox["X Window System lead developer: ",
    FontWeight->"Bold"],
  "\nJohn Cwikla\n\n",
  StyleBox["NeXT lead developers: ",
    FontWeight->"Bold"],
  "\nTheodore W. Gray\nChris Carlson\n\n",
  StyleBox["Additional front end developers:",
    FontWeight->"Bold"],
  "\nJohn Brewer\nThomas Chin\nJohn Fultz\nTodd Gayley\nMike Rasberry\nDoug \
Stein\nDavid Stes\n\n",
  StyleBox["Expression formatting lead developer: ",
    FontWeight->"Bold"],
  "\nNeil Soiffer\n\n",
  StyleBox["Additional expression formatting developers:",
    FontWeight->"Bold"],
  "\nJeff Adams\nRobby Villegas\nTom Wickham-Jones\n\n",
  StyleBox["MathLink lead developer: ",
    FontWeight->"Bold"],
  "\nShawn Sheridan\n\n",
  StyleBox["Standard packages development coordinator: ",
    FontWeight->"Bold"],
  "\nEmily Martin\n\n",
  StyleBox["Lead package developers:",
    FontWeight->"Bold"],
  "\nJerry B. Keiper\nRoman Maeder\nEmily Martin\nJohn Novak\nSteven Skiena\n\
Mark Sofroniou\nAdam Strzebonski\nDavid Withoff\n\n",
  StyleBox["Additional package developers:",
    FontWeight->"Bold"],
  "\nVictor Adamchik\nJeff Adams\nAlexei Bocharov\nGeorge Beck\nMichael Chan\n\
Arun Chandra\nYu He\nDavid Jacobson\nJason Kastner\nRobert Knapp\nMatthew \
Markert\nKevin McIsaac\nMarko Petkovsek\nSirpa Saarinen\nMichael Trott\nIlan \
Vardi\nAudra Wenzlow\nTom Wickham-Jones\nStephen Wolfram\nEran Yehudai\n\n",
  StyleBox["Software engineering managers: ",
    FontWeight->"Bold"],
  "\nRory Murtagh\nSam Roseman\n\n",
  StyleBox["Lead software engineers: ",
    FontWeight->"Bold"],
  "\nRon Fisher\nChris LaReau\nOleg Perelet\nLeland Ray\nPatrick Rice\nMonte \
Seyer\nMakoto Tanabe\n\n",
  StyleBox["Additional software engineers:",
    FontWeight->"Bold"],
  "\nDan Brumleve\nDavid Karner\nChris Lindsey\nPat McGraw\nEd Thomson\nGene \
Van Nostern\n\n",
  StyleBox["Quality assurance manager: ",
    FontWeight->"Bold"],
  "\nScott Midler\n\n",
  StyleBox["Quality assurance lead engineers: ",
    FontWeight->"Bold"],
  "\nJeff Blankenship\nLarry Calmer\nLou D'Andria\nKaren Fernsler\nAnna \
Marichev\nBob Naiman\nMatthew Markert\n\n",
  StyleBox["Additional quality assurance staff/contributors:",
    FontWeight->"Bold"],
  "\nBryce Austin\nScott Brown\nJay Hawkins\nKevin Leuthold\nPatty Merkin\n\
Rolf Mertig\nCourtney Wirth\nJamie Peterson\nJill Smith\n\n",
  StyleBox["Additional senior technical staff:",
    FontWeight->"Bold"],
  "\nIgor Bakshee\nBruce Carpenter\nCetin Cetinkaya\nIan Collier\nRobert \
Dickau\nBen Friedman\nYu He\nBrenda Hunt\nSteve Hunt\nTom Issaevitch\nJohn \
Novak\nTodd Ramsburg\nLeszek Sczaniecki\nLucy Zamiatina\n\n",
  StyleBox["Primary documentation by: ",
    FontWeight->"Bold"],
  "\nStephen Wolfram\n\n",
  StyleBox["Additional documentation by:",
    FontWeight->"Bold"],
  "\nGeorge Beck\nPhilip Boyland\nVicki Bush\nJoe Grohens\nJerry Walsh\nPaul \
Wellin\n\n",
  StyleBox["Editing and production by:",
    FontWeight->"Bold"],
  "\nGeorge Beck\nJoe Kaiping\nJan Progen\nGlenn Scholebo\nPhilip Wall\nJerry \
Walsh\n\n",
  StyleBox["Additional publications staff:",
    FontWeight->"Bold"],
  "\nCaron Allen\nMadhav Chari\nJohn Garvey\nKurt Kessinger\nAngela Latham\n\
Wendy Leung\nCarol Ordal\nLaurie Scoggins\nDoug West\nTimothy Williams\n\n",
  StyleBox["Design director: ",
    FontWeight->"Bold"],
  "\nJohn Bonadies\n\n",
  StyleBox["Graphic designers:",
    FontWeight->"Bold"],
  "\nJody Jasinski\nAndre Kuzniarek\nJennifer Lofgren\nAnn Maroso\nKimberly \
Michael\n\n",
  StyleBox["Lead graphic image creators:",
    FontWeight->"Bold"],
  "\nIgor Bakshee\nGeorge Beck\nMichael Trott\n\n",
  StyleBox["Lead font designer: ",
    FontWeight->"Bold"],
  "\nAndre Kuzniarek\n\n",
  StyleBox["Additional font design by:",
    FontWeight->"Bold"],
  "\nAndy Hunt\nGalapagos, Inc.\nGlenda de Guzman\nY&Y, Inc.\n\n",
  StyleBox["Marketing director:",
    FontWeight->"Bold"],
  "\nJohn Bonadies\n\n",
  StyleBox["Lead product marketing staff:",
    FontWeight->"Bold"],
  "\nHoward Berg\nKatherine Csizmadia\nMonica Davis\nSue Johnson\nCarrie \
Karnopp\nZoe Midler\nClaire Miller\nJon McLoone\nJane Rich\nAlan Skillman\n\
Jelena Spanjol\nChristy Uden\n\n",
  StyleBox["Strategic and international development:",
    FontWeight->"Bold"],
  "\nConrad Wolfram\n\n",
  StyleBox["Overall management:",
    FontWeight->"Bold"],
  "\nStephen Wolfram\n\n\n",
  StyleBox["Dedicated to the memory of Jerry B. Keiper (1953\[Dash]1995)",
    FontSlant->"Italic"]
}], "CreditsText",
  CellTags->"Credits"],

Cell[BoxData[GridBox[{
        {
          ButtonBox["Help",
            ButtonFunction:>(FrontEndExecute[ {
                FrontEnd`HelpBrowserLookup[ #]}]&),
            ButtonData:>""], 
          ButtonBox["\(Contact Information\)",
            ButtonData:>"ContactInformation"], 
          ButtonBox["Credits",
            ButtonData:>"Credits"], 
          ButtonBox["\(License Agreement\)",
            ButtonData:>"LicenseAgreement"], 
          ButtonBox["Top",
            ButtonData:>"Top"], 
          ButtonBox["Print",
            ButtonData:>"LicenseAgreementPrint",
            ButtonStyle->"PrintButton"]}
        }]], "ButtonBar",
  FontFamily->"Helvetica"],

Cell[" ", "RedRule"],

Cell["License Agreement", "SectionHeading",
  CellTags->{"LicenseAgreement", "LicenseAgreementPrint"}],

Cell[CellGroupData[{

Cell["ACCEPTANCE", "LicenseHeading",
  CellTags->"LicenseAgreementPrint"],

Cell["\<\
CAREFULLY READ THE FOLLOWING TERMS AND CONDITIONS BEFORE OPENING \
THE MEDIA CONTAINER. OPENING THE MEDIA CONTAINER INDICATES YOUR ACCEPTANCE OF \
THE TERMS AND CONDITIONS OF THIS AGREEMENT. IF YOU ARE NOT WILLING TO ACCEPT \
THE TERMS AND CONDITIONS OF THIS AGREEMENT, YOU SHOULD RETURN THE ENTIRE \
PRODUCT, WITH THE SEAL ON THE MEDIA CONTAINER UNBROKEN, TO THE PLACE FROM \
WHICH IT WAS OBTAINED FOR A REFUND OF THE PURCHASE PRICE.\
\>", "LicenseText",\

  CellTags->"LicenseAgreementPrint"]
}, Closed]],

Cell[CellGroupData[{

Cell["DEFINITIONS", "LicenseHeading",
  CellTags->"LicenseAgreementPrint"],

Cell[TextData[{
  StyleBox["WRI:",
    FontWeight->"Bold"],
  " Wolfram Research, Inc.\n\n",
  StyleBox["You/Licensee:",
    FontWeight->"Bold"],
  " The purchaser of this license.\n\n",
  StyleBox["Product:",
    FontWeight->"Bold"],
  " All the materials provided with this License Agreement.\n\n",
  StyleBox["Software:",
    FontWeight->"Bold"],
  " The computer programs enclosed in the media container.\n\n",
  StyleBox["License Certificate:",
    FontWeight->"Bold"],
  " The description that indicates specific information about the license to \
use this Product.\n\n",
  StyleBox["Process:",
    FontWeight->"Bold"],
  " Every time the Software is started, a Process is invoked by Your \
computer's operating system. Some versions allow more than one Process to run \
concurrently. Your License Certificate states the maximum number of \
concurrent Processes that You may run.\n\n",
  StyleBox["Product Name:",
    FontWeight->"Bold"],
  " On the line titled Product, Your License Certificate states the name of \
the Product and the type of computer(s) for which the Product is licensed for \
use.\n\n",
  StyleBox["Product Class:",
    FontWeight->"Bold"],
  " A categorization of different ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " products. Your License Certificate states the Product Class to which this \
Product belongs.\n\n",
  StyleBox["Binary Kit(s):",
    FontWeight->"Bold"],
  " If the Product is being provided with Software intended for use with one \
or more other type(s) of computer(s) in addition to the type of computer(s) \
described in the Product section of Your License Certificate, a section \
titled Binary Kit(s) will be printed on Your License Certificate. The Binary \
Kit(s) section lists the additional type(s) of computer(s) for which Software \
is supplied.\n\n",
  StyleBox["Use Class:",
    FontWeight->"Bold"],
  " A categorization of products based on the ways in which they may be used. \
Your License Certificate states the Use Class to which this Product belongs. \
If there are any restrictions on the use of this Product due to its Use \
Class, the restrictions will be written on the License Certificate.\n\n",
  StyleBox["License Class:",
    FontWeight->"Bold"],
  " A categorization of different ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " licenses that indicates how the Product may be run on a network of \
computers. The License Classes are Single-Machine and Network. Your License \
Certificate states the License Class to which this Product belongs.\n\n",
  StyleBox["Single-Machine License:",
    FontWeight->"Bold"],
  " The Single-Machine License allows one or more users to run ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " on a single machine that contains the \"host\" CPU for the ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " kernel.\n\n",
  StyleBox["Single-User License:",
    FontWeight->"Bold"],
  " A Single-Machine License for a single user.\n\n",
  StyleBox["Network License:",
    FontWeight->"Bold"],
  " The Network License is designed to accommodate a network environment. A \
server program allows a predetermined number of Processes to run concurrently \
on the network. A Process may be invoked only on a computer associated with \
the same or lesser Product Class as listed on Your License Certificate."
}], "LicenseText",
  CellTags->"LicenseAgreementPrint"]
}, Closed]],

Cell[CellGroupData[{

Cell["OWNERSHIP", "LicenseHeading",
  CellTags->"LicenseAgreementPrint"],

Cell["\<\
WRI is the sole owner of the Software contained in this package \
with the exception of portions of Software licensed by WRI from other firms, \
which are the owners of those portions.

WRI is the holder of the copyright to the Software, including without \
limitation such aspects of the Software as its code, structure, sequence, \
organization, \"look and feel\", programming language and compilation of \
command names. Use of the Software unless pursuant to the terms of a license \
granted by WRI or as otherwise authorized by law is an infringement of the \
copyright.\
\>", "LicenseText",
  CellTags->"LicenseAgreementPrint"]
}, Closed]],

Cell[CellGroupData[{

Cell["PERMITTED USES", "LicenseHeading",
  CellTags->"LicenseAgreementPrint"],

Cell[TextData[{
  "Provided that You accept this License Agreement, WRI grants You a \
non-exclusive license to use the Product. The Software may be run on the \
type(s) of computer(s) described in the Product section of Your License \
Certificate. If there is a Binary Kit(s) section in Your License Certificate, \
You may also use the version(s) of the Software described as being intended \
for use with other types of computers with those other types of computers. If \
your License Class is a Single-Machine License, You are authorized to run \
concurrent Processes up to the maximum number specified on Your License \
Certificate; however, all Processes must run on a single computer. If Your \
License Class is a Network License, You are authorized to run concurrent \
Processes up to the maximum number specified on Your License Certificate, \
provided that all the Processes are run on computers in the same network. \
Your license terminates in the event that You receive a license to use an \
upgraded version of the Product in place of the Product. If a license \
expiration date is printed on Your License Certificate, Your license to use \
the Product terminates on that day. You are also authorized to:\n\n",
  StyleBox["a.",
    FontWeight->"Bold"],
  " install the Software on a single on-line storage device (for example, a \
hard disk drive);\n\n",
  StyleBox["b.",
    FontWeight->"Bold"],
  " maintain an archival copy of the Software on off-line storage media (such \
as diskettes);\n\n",
  StyleBox["c.",
    FontWeight->"Bold"],
  " transfer the license subject to the following conditions: (1) Your Use \
Class permits the transfer of this license; (2) The transferee's use of the \
license falls into the same Use Class, as specified on the License \
Certificate; (3) You notify WRI in writing of Your decision to transfer this \
license and certify that You have destroyed or given to the transferee all \
copies of the Software and other elements of the Product that You have ever \
had; (4) The transferee accepts all the terms and conditions of this \
license."
}], "LicenseText",
  CellTags->"LicenseAgreementPrint"]
}, Closed]],

Cell[CellGroupData[{

Cell["PROHIBITED USES", "LicenseHeading",
  CellTags->"LicenseAgreementPrint"],

Cell[TextData[{
  "All uses of the Software and other elements of the Product not \
specifically allowed in the Permitted Uses section of this License Agreement \
are prohibited. The following is a partial list of prohibited uses of the \
Product. This license does not allow You to:\n\n",
  StyleBox["a. ",
    FontWeight->"Bold"],
  "run more Processes concurrently than the maximum specified on Your License \
Certificate;\n\n",
  StyleBox["b. ",
    FontWeight->"Bold"],
  "run the Software on a computer associated with a Product Class greater \
than the Product Class specified on the License Certificate;\n\n",
  StyleBox["c. ",
    FontWeight->"Bold"],
  "run the Software described in the Product and Binary Kit(s) (if present) \
section(s) of Your License Certificate on a computer of a type other than the \
type(s) of computer(s) described in the Product and Binary Kit(s) (if \
present) section(s);\n\n",
  StyleBox["d. ",
    FontWeight->"Bold"],
  "use the Product in a manner that violates the restrictions associated with \
the Use Class specified on the License Certificate;\n\n",
  StyleBox["e. ",
    FontWeight->"Bold"],
  "use portions of the Software on separate computers (The Software may \
contain multiple executables (e.g., kernel, front end, other programs); \
executables may not be installed or used on separate computers, even if the \
use is not concurrent. In the case of multiple process licenses, the use of \
one or more executables, but not more than one kernel, on a computer is the \
equivalent of the use of a single Process on that computer. In the case of \
Network Licenses, the use of a front end executable that is linked to an \
active kernel on a second computer is counted as a single Process.);\n\n",
  StyleBox["f. ",
    FontWeight->"Bold"],
  "decompile or reverse engineer the Software;\n\n",
  StyleBox["g. ",
    FontWeight->"Bold"],
  "modify the Software in any manner, except those portions written in the ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " language and included as standard ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " packages;\n\n",
  StyleBox["h. ",
    FontWeight->"Bold"],
  "sublicense, lend, lease or rent the Software or any portion of the \
Software;\n\n",
  StyleBox["i. ",
    FontWeight->"Bold"],
  "copy or allow copying of the Software and other elements of the Product, \
except as permitted for the maintenance of an archival copy of the Software."
}], "LicenseText",
  CellTags->"LicenseAgreementPrint"]
}, Closed]],

Cell[CellGroupData[{

Cell["MULTIPLE NETWORK LICENSES", "LicenseHeading",
  CellTags->"LicenseAgreementPrint"],

Cell["\<\
If this is a Network License, when at least one Process associated \
with this license is not being used, another Network License of the same or \
lesser Product Class and of the same or lesser version number (the version \
number is specified in the Product section of the License Certificate), and \
which is installed on the same computer as this license, may be used as \
though the number of Processes associated with the latter license was \
increased by the number of unused Processes associated with this license. If \
this is done, the Processes may not be used with this license until the other \
license ceases to use them. To use this feature You must follow the \
instructions provided with both this Product and the other Network License \
Product.\
\>", "LicenseText",
  CellTags->"LicenseAgreementPrint"]
}, Closed]],

Cell[CellGroupData[{

Cell["LIMITED WARRANTY", "LicenseHeading",
  CellTags->"LicenseAgreementPrint"],

Cell["\<\
WRI warrants that the Product shall be free from defects in the \
physical media for a period of ninety days following date of purchase when \
used under normal conditions. THE FOREGOING WARRANTY IS IN LIEU OF ALL OTHER \
WARRANTIES, EXPRESS OR IMPLIED. WRI DOES NOT WARRANT THAT THE SOFTWARE IS \
FREE FROM ALL BUGS AND OMISSIONS; THE PRODUCT IS SOLD AS IS. WRI MAKES NO \
REPRESENTATIONS, EXPRESS OR IMPLIED, WITH RESPECT TO THE PRODUCT OR THE \
SOFTWARE CONTAINED IN THE PRODUCT, INCLUDING WITHOUT LIMITATIONS, ANY IMPLIED \
WARRANTIES OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE, ALL OF \
WHICH IS EXPRESSLY DISCLAIMED. WRI DOES NOT WARRANT THAT THE FUNCTIONS \
CONTAINED IN THE PROGRAM WILL MEET YOUR REQUIREMENTS OR THAT THE OPERATION OF \
THE PROGRAM WILL BE UNINTERRUPTED OR ERROR FREE.

IN ADDITION TO THE FOREGOING, YOU SHOULD RECOGNIZE THAT ALL COMPLEX SOFTWARE \
SYSTEMS AND THEIR DOCUMENTATION CONTAIN ERRORS AND OMISSIONS. WRI, ITS \
DISTRIBUTORS AND DEALERS SHALL NOT BE RESPONSIBLE UNDER ANY CIRCUMSTANCES FOR \
PROVIDING INFORMATION ON OR CORRECTIONS TO ERRORS AND OMISSIONS DISCOVERED AT \
ANY TIME IN THE PRODUCT, WHETHER OR NOT THEY ARE AWARE OF THE ERRORS OR \
OMISSIONS. WRI DOES NOT RECOMMEND THE USE OF THE SOFTWARE FOR APPLICATIONS IN \
WHICH ERRORS OR OMISSIONS COULD THREATEN LIFE, INJURY OR SIGNIFICANT LOSS.

SOME STATES DO NOT ALLOW THE EXCLUSION OF IMPLIED WARRANTIES, SO THIS MAY NOT \
APPLY TO YOU. THIS WARRANTY GIVES YOU SPECIFIC LEGAL RIGHTS, AND YOU MAY ALSO \
HAVE OTHER RIGHTS WHICH VARY FROM STATE TO STATE. This License Agreement \
shall be construed under the laws of the State of Illinois.\
\>", 
  "LicenseText",
  CellTags->"LicenseAgreementPrint"]
}, Closed]],

Cell[CellGroupData[{

Cell["LIMITED DAMAGES", "LicenseHeading",
  CellTags->"LicenseAgreementPrint"],

Cell["\<\
IN NO EVENT SHALL WRI, ITS DISTRIBUTORS AND DEALERS BE LIABLE FOR \
ANY LOST PROFITS, LOST BENEFITS, OR ANY CONSEQUENTIAL, INDIRECT, INCIDENTAL, \
SPECIAL OR PUNITIVE DAMAGES, WHETHER IN CONTRACT OR IN TORT, EVEN IF WRI HAS \
BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGES. DIRECT DAMAGES ARE LIMITED \
TO THE AMOUNT OF THE PURCHASE PRICE PAID FOR THE PRODUCT. Some states do not \
allow certain limitations of damages, so the above limitations may not apply \
to you. 
\
\>", "LicenseText",
  CellTags->"LicenseAgreementPrint"]
}, Closed]],

Cell[CellGroupData[{

Cell["UNITED STATES FEDERAL GOVERNMENT RESTRICTED RIGHTS", "LicenseHeading",
  CellTags->"LicenseAgreementPrint"],

Cell["\<\
If this Software is acquired by or on behalf of the U.S. Federal \
government, this provision applies. Use, duplication or disclosure of this \
Software is subject to restrictions set forth in FAR 52.227-19 and DFAR \
252.227-7013, as applicable. The Software is \"commercial computer software\" \
and is licensed with only \"Restricted Rights.\" \
\>", "LicenseText",
  CellTags->"LicenseAgreementPrint"]
}, Closed]]
},
FrontEndVersion->"Macintosh 3.0",
ScreenRectangle->{{0, 640}, {0, 460}},
Editable->False,
ScreenStyleEnvironment->"Working",
WindowToolbars->{},
CellGrouping->Manual,
WindowSize->{371, 377},
WindowMargins->{{68, Automatic}, {Automatic, 12}},
WindowFrame->"Palette",
WindowElements->"VerticalScrollBar",
WindowFrameElements->"CloseBox",
PrintingCopies->1,
PrintingPageRange->{1, Automatic},
ShowCellBracket->False,
CellMargins->{{0, 10}, {0, 0}},
ShowCellTags->False,
Magnification->1,
StyleDefinitions -> Notebook[{
  
  Cell[CellGroupData[{
  Cell["Style Definitions", "Subtitle"],
  
  Cell["\<\
Modify the definitions below to change the default appearance of \
all cells in a given style.
Make modifications to any definition using commands in the Format menu.\
\>", 
    "Text"],
  
  Cell[CellGroupData[{
  
  Cell["Style Environment Names", "Section"],
  
  Cell[StyleData[All, "Working"],
    ScriptMinSize->9],
  
  Cell[StyleData[All, "Presentation"],
    ScriptMinSize->12,
    FontSize->18],
  
  Cell[StyleData[All, "Condensed"],
    PageWidth->WindowWidth,
    CellLabelMargins->{{4, Inherited}, {Inherited, Inherited}},
    LineSpacing->{1, 0},
    ScriptMinSize->8,
    FontSize->10],
  
  Cell[StyleData[All, "Printout"],
    PageWidth->PaperWidth,
    FontSize->10,
    PrivateFontOptions->{"FontType"->"Outline"}]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell["General Styles", "Section"],
  
  Cell[StyleData["SectionHeading"],
    CellMargins->{{10, 10}, {30, 4}},
    FontFamily->"Helvetica",
    FontSize->18,
    FontWeight->"Bold"],
  
  Cell[StyleData["ButtonBar"],
    CellMargins->{{5, 5}, {10, 10}},
    Active->True,
    TextAlignment->Center,
    FontFamily->"Helvetica",
    FontSize->10,
    FontWeight->"Bold",
    ButtonBoxOptions->{ButtonFunction:>(FrontEndExecute[ {
        FrontEnd`NotebookLocate[ {
          FrontEnd`ButtonNotebook[ ], #2}]}]&)},
    GridBoxOptions->{RowSpacings->0,
    ColumnSpacings->0,
    GridDefaultElement:>ButtonBox[ "\\[Placeholder]"]}],
  
  Cell[StyleData["PrintButton"],
    CellMargins->{{5, 5}, {10, 10}},
    Active->True,
    FontFamily->"Helvetica",
    FontSize->10,
    ButtonBoxOptions->{ButtonFunction:>(FrontEndExecute[ {
        FrontEnd`NotebookLocate[ {
          FrontEnd`ButtonNotebook[ ], #2}], 
        FrontEndToken[ 
          FrontEnd`ButtonNotebook[ ], "SelectionOpenAllGroups"], 
        FrontEnd`NotebookPrint[ 
          FrontEnd`NotebookSelection[ 
            FrontEnd`ButtonNotebook[ ]], Interactive -> True]}]&)}],
  
  Cell[StyleData["RedRule"],
    CellMargins->{{0, 0}, {0, 0}},
    CellFrameMargins->False,
    FontSize->4,
    Background->RGBColor[0.95201, 0.0914931, 0.141176]]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell["Styles for Top Matter", "Section"],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["TopMatter"],
    CellFrameMargins->{{8, 8}, {5, 5}},
    FontFamily->"Helvetica",
    FontSize->10,
    FontColor->GrayLevel[1],
    Background->GrayLevel[0]],
  
  Cell[StyleData["TopMatter", "Presentation"],
    FontSize->12],
  
  Cell[StyleData["TopMatter", "Printout"],
    FontSize->10,
    FontColor->GrayLevel[0],
    Background->GrayLevel[1]]
  }, Closed]]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell["Styles for Contact Information", "Section"],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["ContactHeading"],
    CellFrame->True,
    CellMargins->{{10, 10}, {0, 10}},
    FontFamily->"Helvetica",
    FontSize->14,
    FontWeight->"Bold",
    FontColor->GrayLevel[1],
    Background->GrayLevel[0]],
  
  Cell[StyleData["ContactHeading", "Presentation"],
    FontSize->18],
  
  Cell[StyleData["ContactHeading", "Printout"],
    FontSize->10,
    FontColor->GrayLevel[0],
    Background->GrayLevel[1]]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["ContactText"],
    CellFrame->True,
    CellMargins->{{10, 10}, {10, 0}},
    FontFamily->"Helvetica",
    FontSize->12,
    Background->GrayLevel[0.760876]],
  
  Cell[StyleData["ContactText", "Presentation"],
    FontSize->18],
  
  Cell[StyleData["ContactText", "Printout"],
    FontSize->10,
    FontColor->GrayLevel[0],
    Background->GrayLevel[1]]
  }, Closed]]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell["Styles for Credits", "Section"],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["CreditsText"],
    CellMargins->{{43, 10}, {4, 4}},
    FontFamily->"Helvetica",
    FontSize->10],
  
  Cell[StyleData["CreditsText", "Presentation"],
    FontSize->18],
  
  Cell[StyleData["CreditsText", "Printout"],
    FontSize->10]
  }, Closed]]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell["Styles for License Agreement", "Section"],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["LicenseHeading"],
    CellFrame->True,
    ShowGroupOpenCloseIcon->True,
    CellMargins->{{10, 10}, {-1, 5}},
    CellGroupingRules->{"SectionGrouping", 40},
    PageBreakBelow->False,
    CounterIncrements->"Subsection",
    CounterAssignments->{{"Subsubsection", 0}},
    FontFamily->"Helvetica",
    FontSize->14,
    FontWeight->"Bold",
    Background->RGBColor[0.897353, 0.836332, 0.551919]],
  
  Cell[StyleData["LicenseHeading", "Presentation"],
    FontSize->18],
  
  Cell[StyleData["LicenseHeading", "Printout"],
    FontSize->10,
    FontColor->GrayLevel[0],
    Background->GrayLevel[1]]
  }, Closed]],
  
  Cell[CellGroupData[{
  
  Cell[StyleData["LicenseText"],
    CellFrame->True,
    CellMargins->{{20, 10}, {5, 0}},
    FontFamily->"Helvetica",
    FontSize->12,
    Background->RGBColor[0.98967, 0.57557, 0.83003]],
  
  Cell[StyleData["LicenseText", "Presentation"],
    FontSize->18],
  
  Cell[StyleData["LicenseText", "Printout"],
    FontSize->10,
    FontColor->GrayLevel[0],
    Background->GrayLevel[1]]
  }, Closed]]
  }, Closed]]
  }, Open  ]]
  }],
MacintoshSystemPageSetup->"\<\
00<0001804P000000]P2:?oQon82n@960dL5:0?l0080001804P000000]P2:001
0000I00000400`<300000BL?00400@00000000000000060801T1T00000000000
00000000000000000000000000000000\>"
]


(***********************************************************************
Cached data follows.  If you edit this Notebook file directly, not using
Mathematica, you must remove the line containing CacheID at the top of 
the file.  The cache data will then be recreated when you save this file 
from within Mathematica.
***********************************************************************)

(*CellTagsOutline
CellTagsIndex->{
  "Top"->{
    Cell[1710, 49, 774, 22, 27, "ButtonBar",
      CellTags->"Top"],
    Cell[2487, 73, 201, 4, 23, "TopMatter",
      CellTags->"Top"],
    Cell[2691, 79, 67838, 845, 193, 67529, 835, "GraphicsData", 
    "Bitmap", "Graphics",
      CellTags->"Top"],
    Cell[70532, 926, 283, 10, 62, "TopMatter",
      CellTags->"Top"],
    Cell[70818, 938, 489, 12, 111, "TopMatter",
      CellTags->"Top"]},
  "ContactInformation"->{
    Cell[72007, 974, 79, 1, 54, "SectionHeading",
      CellTags->"ContactInformation"],
    Cell[72111, 979, 74, 1, 42, "ContactHeading",
      CellTags->"ContactInformation"],
    Cell[72188, 982, 247, 4, 101, "ContactText",
      CellTags->"ContactInformation"],
    Cell[72472, 991, 146, 5, 42, "ContactHeading",
      CellTags->"ContactInformation"],
    Cell[72621, 998, 416, 11, 161, "ContactText",
      CellTags->"ContactInformation"],
    Cell[73074, 1014, 136, 3, 42, "ContactHeading",
      CellTags->"ContactInformation"],
    Cell[73213, 1019, 640, 17, 221, "ContactText",
      CellTags->"ContactInformation"],
    Cell[73890, 1041, 139, 3, 42, "ContactHeading",
      CellTags->"ContactInformation"],
    Cell[74032, 1046, 1086, 36, 356, "ContactText",
      CellTags->"ContactInformation"],
    Cell[75155, 1087, 254, 9, 58, "ContactHeading",
      CellTags->"ContactInformation"],
    Cell[75412, 1098, 1219, 40, 311, "ContactText",
      CellTags->"ContactInformation"],
    Cell[76668, 1143, 135, 3, 42, "ContactHeading",
      CellTags->"ContactInformation"],
    Cell[76806, 1148, 953, 26, 416, "ContactText",
      CellTags->"ContactInformation"]},
  "Credits"->{
    Cell[78460, 1199, 56, 1, 54, "SectionHeading",
      CellTags->"Credits"],
    Cell[78519, 1202, 5551, 135, 3155, "CreditsText",
      CellTags->"Credits"]},
  "LicenseAgreement"->{
    Cell[84775, 1361, 102, 1, 54, "SectionHeading",
      CellTags->{"LicenseAgreement", "LicenseAgreementPrint"}]},
  "LicenseAgreementPrint"->{
    Cell[84775, 1361, 102, 1, 54, "SectionHeading",
      CellTags->{"LicenseAgreement", "LicenseAgreementPrint"}],
    Cell[84902, 1366, 73, 1, 36, "LicenseHeading",
      CellTags->"LicenseAgreementPrint"],
    Cell[84978, 1369, 504, 9, 70, "LicenseText",
      CellTags->"LicenseAgreementPrint"],
    Cell[85519, 1383, 74, 1, 35, "LicenseHeading",
      CellTags->"LicenseAgreementPrint"],
    Cell[85596, 1386, 3399, 76, 70, "LicenseText",
      CellTags->"LicenseAgreementPrint"],
    Cell[89032, 1467, 72, 1, 35, "LicenseHeading",
      CellTags->"LicenseAgreementPrint"],
    Cell[89107, 1470, 643, 12, 70, "LicenseText",
      CellTags->"LicenseAgreementPrint"],
    Cell[89787, 1487, 77, 1, 35, "LicenseHeading",
      CellTags->"LicenseAgreementPrint"],
    Cell[89867, 1490, 2147, 36, 70, "LicenseText",
      CellTags->"LicenseAgreementPrint"],
    Cell[92051, 1531, 78, 1, 35, "LicenseHeading",
      CellTags->"LicenseAgreementPrint"],
    Cell[92132, 1534, 2518, 54, 70, "LicenseText",
      CellTags->"LicenseAgreementPrint"],
    Cell[94687, 1593, 88, 1, 35, "LicenseHeading",
      CellTags->"LicenseAgreementPrint"],
    Cell[94778, 1596, 830, 13, 70, "LicenseText",
      CellTags->"LicenseAgreementPrint"],
    Cell[95645, 1614, 79, 1, 35, "LicenseHeading",
      CellTags->"LicenseAgreementPrint"],
    Cell[95727, 1617, 1714, 27, 70, "LicenseText",
      CellTags->"LicenseAgreementPrint"],
    Cell[97478, 1649, 78, 1, 35, "LicenseHeading",
      CellTags->"LicenseAgreementPrint"],
    Cell[97559, 1652, 539, 10, 70, "LicenseText",
      CellTags->"LicenseAgreementPrint"],
    Cell[98135, 1667, 113, 1, 51, "LicenseHeading",
      CellTags->"LicenseAgreementPrint"],
    Cell[98251, 1670, 415, 7, 70, "LicenseText",
      CellTags->"LicenseAgreementPrint"]}
  }
*)

(*CellTagsIndex
CellTagsIndex->{
  {"Top", 105097, 1927},
  {"ContactInformation", 105519, 1939},
  {"Credits", 106706, 1966},
  {"LicenseAgreement", 106892, 1971},
  {"LicenseAgreementPrint", 107038, 1974}
  }
*)

(*NotebookFileOutline
Notebook[{
Cell[1710, 49, 774, 22, 27, "ButtonBar",
  CellTags->"Top"],
Cell[2487, 73, 201, 4, 23, "TopMatter",
  CellTags->"Top"],
Cell[2691, 79, 67838, 845, 193, 67529, 835, "GraphicsData", 
"Bitmap", "Graphics",
  CellTags->"Top"],
Cell[70532, 926, 283, 10, 62, "TopMatter",
  CellTags->"Top"],
Cell[70818, 938, 489, 12, 111, "TopMatter",
  CellTags->"Top"],
Cell[71310, 952, 671, 18, 39, "ButtonBar"],
Cell[71984, 972, 20, 0, 12, "RedRule"],
Cell[72007, 974, 79, 1, 54, "SectionHeading",
  CellTags->"ContactInformation"],

Cell[CellGroupData[{
Cell[72111, 979, 74, 1, 42, "ContactHeading",
  CellTags->"ContactInformation"],
Cell[72188, 982, 247, 4, 101, "ContactText",
  CellTags->"ContactInformation"]
}, Open  ]],

Cell[CellGroupData[{
Cell[72472, 991, 146, 5, 42, "ContactHeading",
  CellTags->"ContactInformation"],
Cell[72621, 998, 416, 11, 161, "ContactText",
  CellTags->"ContactInformation"]
}, Open  ]],

Cell[CellGroupData[{
Cell[73074, 1014, 136, 3, 42, "ContactHeading",
  CellTags->"ContactInformation"],
Cell[73213, 1019, 640, 17, 221, "ContactText",
  CellTags->"ContactInformation"]
}, Open  ]],

Cell[CellGroupData[{
Cell[73890, 1041, 139, 3, 42, "ContactHeading",
  CellTags->"ContactInformation"],
Cell[74032, 1046, 1086, 36, 356, "ContactText",
  CellTags->"ContactInformation"]
}, Open  ]],

Cell[CellGroupData[{
Cell[75155, 1087, 254, 9, 58, "ContactHeading",
  CellTags->"ContactInformation"],
Cell[75412, 1098, 1219, 40, 311, "ContactText",
  CellTags->"ContactInformation"]
}, Open  ]],

Cell[CellGroupData[{
Cell[76668, 1143, 135, 3, 42, "ContactHeading",
  CellTags->"ContactInformation"],
Cell[76806, 1148, 953, 26, 416, "ContactText",
  CellTags->"ContactInformation"]
}, Open  ]],
Cell[77774, 1177, 660, 18, 39, "ButtonBar"],
Cell[78437, 1197, 20, 0, 12, "RedRule"],
Cell[78460, 1199, 56, 1, 54, "SectionHeading",
  CellTags->"Credits"],
Cell[78519, 1202, 5551, 135, 3155, "CreditsText",
  CellTags->"Credits"],
Cell[84073, 1339, 676, 18, 39, "ButtonBar"],
Cell[84752, 1359, 20, 0, 12, "RedRule"],
Cell[84775, 1361, 102, 1, 54, "SectionHeading",
  CellTags->{"LicenseAgreement", "LicenseAgreementPrint"}],

Cell[CellGroupData[{
Cell[84902, 1366, 73, 1, 36, "LicenseHeading",
  CellTags->"LicenseAgreementPrint"],
Cell[84978, 1369, 504, 9, 70, "LicenseText",
  CellTags->"LicenseAgreementPrint"]
}, Closed]],

Cell[CellGroupData[{
Cell[85519, 1383, 74, 1, 35, "LicenseHeading",
  CellTags->"LicenseAgreementPrint"],
Cell[85596, 1386, 3399, 76, 70, "LicenseText",
  CellTags->"LicenseAgreementPrint"]
}, Closed]],

Cell[CellGroupData[{
Cell[89032, 1467, 72, 1, 35, "LicenseHeading",
  CellTags->"LicenseAgreementPrint"],
Cell[89107, 1470, 643, 12, 70, "LicenseText",
  CellTags->"LicenseAgreementPrint"]
}, Closed]],

Cell[CellGroupData[{
Cell[89787, 1487, 77, 1, 35, "LicenseHeading",
  CellTags->"LicenseAgreementPrint"],
Cell[89867, 1490, 2147, 36, 70, "LicenseText",
  CellTags->"LicenseAgreementPrint"]
}, Closed]],

Cell[CellGroupData[{
Cell[92051, 1531, 78, 1, 35, "LicenseHeading",
  CellTags->"LicenseAgreementPrint"],
Cell[92132, 1534, 2518, 54, 70, "LicenseText",
  CellTags->"LicenseAgreementPrint"]
}, Closed]],

Cell[CellGroupData[{
Cell[94687, 1593, 88, 1, 35, "LicenseHeading",
  CellTags->"LicenseAgreementPrint"],
Cell[94778, 1596, 830, 13, 70, "LicenseText",
  CellTags->"LicenseAgreementPrint"]
}, Closed]],

Cell[CellGroupData[{
Cell[95645, 1614, 79, 1, 35, "LicenseHeading",
  CellTags->"LicenseAgreementPrint"],
Cell[95727, 1617, 1714, 27, 70, "LicenseText",
  CellTags->"LicenseAgreementPrint"]
}, Closed]],

Cell[CellGroupData[{
Cell[97478, 1649, 78, 1, 35, "LicenseHeading",
  CellTags->"LicenseAgreementPrint"],
Cell[97559, 1652, 539, 10, 70, "LicenseText",
  CellTags->"LicenseAgreementPrint"]
}, Closed]],

Cell[CellGroupData[{
Cell[98135, 1667, 113, 1, 51, "LicenseHeading",
  CellTags->"LicenseAgreementPrint"],
Cell[98251, 1670, 415, 7, 70, "LicenseText",
  CellTags->"LicenseAgreementPrint"]
}, Closed]]
}
]
*)




(***********************************************************************
End of Mathematica Notebook file.
***********************************************************************)

